package zio.aws.timestreamwrite.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchLoadProgressReport(
    recordsProcessed: Optional[Long] = Optional.Absent,
    recordsIngested: Optional[Long] = Optional.Absent,
    parseFailures: Optional[Long] = Optional.Absent,
    recordIngestionFailures: Optional[Long] = Optional.Absent,
    fileFailures: Optional[Long] = Optional.Absent,
    bytesMetered: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.BatchLoadProgressReport = {
    import BatchLoadProgressReport.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.BatchLoadProgressReport
      .builder()
      .optionallyWith(recordsProcessed.map(value => value: java.lang.Long))(
        _.recordsProcessed
      )
      .optionallyWith(recordsIngested.map(value => value: java.lang.Long))(
        _.recordsIngested
      )
      .optionallyWith(parseFailures.map(value => value: java.lang.Long))(
        _.parseFailures
      )
      .optionallyWith(
        recordIngestionFailures.map(value => value: java.lang.Long)
      )(_.recordIngestionFailures)
      .optionallyWith(fileFailures.map(value => value: java.lang.Long))(
        _.fileFailures
      )
      .optionallyWith(bytesMetered.map(value => value: java.lang.Long))(
        _.bytesMetered
      )
      .build()
  }
  def asReadOnly
      : zio.aws.timestreamwrite.model.BatchLoadProgressReport.ReadOnly =
    zio.aws.timestreamwrite.model.BatchLoadProgressReport.wrap(buildAwsValue())
}
object BatchLoadProgressReport {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.BatchLoadProgressReport
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.BatchLoadProgressReport =
      zio.aws.timestreamwrite.model.BatchLoadProgressReport(
        recordsProcessed.map(value => value),
        recordsIngested.map(value => value),
        parseFailures.map(value => value),
        recordIngestionFailures.map(value => value),
        fileFailures.map(value => value),
        bytesMetered.map(value => value)
      )
    def recordsProcessed: Optional[Long]
    def recordsIngested: Optional[Long]
    def parseFailures: Optional[Long]
    def recordIngestionFailures: Optional[Long]
    def fileFailures: Optional[Long]
    def bytesMetered: Optional[Long]
    def getRecordsProcessed: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("recordsProcessed", recordsProcessed)
    def getRecordsIngested: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("recordsIngested", recordsIngested)
    def getParseFailures: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("parseFailures", parseFailures)
    def getRecordIngestionFailures: ZIO[Any, AwsError, Long] = AwsError
      .unwrapOptionField("recordIngestionFailures", recordIngestionFailures)
    def getFileFailures: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("fileFailures", fileFailures)
    def getBytesMetered: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("bytesMetered", bytesMetered)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.BatchLoadProgressReport
  ) extends zio.aws.timestreamwrite.model.BatchLoadProgressReport.ReadOnly {
    override val recordsProcessed: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.recordsProcessed())
      .map(value => value: Long)
    override val recordsIngested: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.recordsIngested())
      .map(value => value: Long)
    override val parseFailures: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.parseFailures())
      .map(value => value: Long)
    override val recordIngestionFailures: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.recordIngestionFailures())
      .map(value => value: Long)
    override val fileFailures: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.fileFailures())
      .map(value => value: Long)
    override val bytesMetered: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.bytesMetered())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.BatchLoadProgressReport
  ): zio.aws.timestreamwrite.model.BatchLoadProgressReport.ReadOnly =
    new Wrapper(impl)
}
