package zio.aws.timestreamwrite.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Schema(
    compositePartitionKey: Optional[
      Iterable[zio.aws.timestreamwrite.model.PartitionKey]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.Schema = {
    import Schema.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.Schema
      .builder()
      .optionallyWith(
        compositePartitionKey.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.compositePartitionKey)
      .build()
  }
  def asReadOnly: zio.aws.timestreamwrite.model.Schema.ReadOnly =
    zio.aws.timestreamwrite.model.Schema.wrap(buildAwsValue())
}
object Schema {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.Schema
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.Schema =
      zio.aws.timestreamwrite.model.Schema(
        compositePartitionKey.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def compositePartitionKey
        : Optional[List[zio.aws.timestreamwrite.model.PartitionKey.ReadOnly]]
    def getCompositePartitionKey: ZIO[Any, AwsError, List[
      zio.aws.timestreamwrite.model.PartitionKey.ReadOnly
    ]] =
      AwsError.unwrapOptionField("compositePartitionKey", compositePartitionKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.Schema
  ) extends zio.aws.timestreamwrite.model.Schema.ReadOnly {
    override val compositePartitionKey
        : Optional[List[zio.aws.timestreamwrite.model.PartitionKey.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compositePartitionKey())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.timestreamwrite.model.PartitionKey.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.Schema
  ): zio.aws.timestreamwrite.model.Schema.ReadOnly = new Wrapper(impl)
}
