package zio.aws.timestreamwrite.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.timestreamwrite.model.primitives.PageLimit
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListBatchLoadTasksRequest(
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[PageLimit] = Optional.Absent,
    taskStatus: Optional[zio.aws.timestreamwrite.model.BatchLoadStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.ListBatchLoadTasksRequest = {
    import ListBatchLoadTasksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.ListBatchLoadTasksRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => PageLimit.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(taskStatus.map(value => value.unwrap))(_.taskStatus)
      .build()
  }
  def asReadOnly
      : zio.aws.timestreamwrite.model.ListBatchLoadTasksRequest.ReadOnly =
    zio.aws.timestreamwrite.model.ListBatchLoadTasksRequest
      .wrap(buildAwsValue())
}
object ListBatchLoadTasksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.ListBatchLoadTasksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.ListBatchLoadTasksRequest =
      zio.aws.timestreamwrite.model.ListBatchLoadTasksRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        taskStatus.map(value => value)
      )
    def nextToken: Optional[String]
    def maxResults: Optional[PageLimit]
    def taskStatus: Optional[zio.aws.timestreamwrite.model.BatchLoadStatus]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, PageLimit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getTaskStatus
        : ZIO[Any, AwsError, zio.aws.timestreamwrite.model.BatchLoadStatus] =
      AwsError.unwrapOptionField("taskStatus", taskStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.ListBatchLoadTasksRequest
  ) extends zio.aws.timestreamwrite.model.ListBatchLoadTasksRequest.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[PageLimit] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.timestreamwrite.model.primitives.PageLimit(value))
    override val taskStatus
        : Optional[zio.aws.timestreamwrite.model.BatchLoadStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskStatus())
        .map(value => zio.aws.timestreamwrite.model.BatchLoadStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.ListBatchLoadTasksRequest
  ): zio.aws.timestreamwrite.model.ListBatchLoadTasksRequest.ReadOnly =
    new Wrapper(impl)
}
