package zio.aws.timestreamwrite.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class WriteRecordsResponse(
    recordsIngested: Optional[zio.aws.timestreamwrite.model.RecordsIngested] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.WriteRecordsResponse = {
    import WriteRecordsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.WriteRecordsResponse
      .builder()
      .optionallyWith(recordsIngested.map(value => value.buildAwsValue()))(
        _.recordsIngested
      )
      .build()
  }
  def asReadOnly: zio.aws.timestreamwrite.model.WriteRecordsResponse.ReadOnly =
    zio.aws.timestreamwrite.model.WriteRecordsResponse.wrap(buildAwsValue())
}
object WriteRecordsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.WriteRecordsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.WriteRecordsResponse =
      zio.aws.timestreamwrite.model
        .WriteRecordsResponse(recordsIngested.map(value => value.asEditable))
    def recordsIngested
        : Optional[zio.aws.timestreamwrite.model.RecordsIngested.ReadOnly]
    def getRecordsIngested: ZIO[
      Any,
      AwsError,
      zio.aws.timestreamwrite.model.RecordsIngested.ReadOnly
    ] = AwsError.unwrapOptionField("recordsIngested", recordsIngested)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.WriteRecordsResponse
  ) extends zio.aws.timestreamwrite.model.WriteRecordsResponse.ReadOnly {
    override val recordsIngested
        : Optional[zio.aws.timestreamwrite.model.RecordsIngested.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recordsIngested())
        .map(value => zio.aws.timestreamwrite.model.RecordsIngested.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.WriteRecordsResponse
  ): zio.aws.timestreamwrite.model.WriteRecordsResponse.ReadOnly = new Wrapper(
    impl
  )
}
