package zio.aws.timestreamwrite.model
import zio.aws.timestreamwrite.model.primitives.SchemaName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MultiMeasureMappings(
    targetMultiMeasureName: Optional[SchemaName] = Optional.Absent,
    multiMeasureAttributeMappings: Iterable[
      zio.aws.timestreamwrite.model.MultiMeasureAttributeMapping
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.MultiMeasureMappings = {
    import MultiMeasureMappings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.MultiMeasureMappings
      .builder()
      .optionallyWith(
        targetMultiMeasureName.map(value =>
          SchemaName.unwrap(value): java.lang.String
        )
      )(_.targetMultiMeasureName)
      .multiMeasureAttributeMappings(multiMeasureAttributeMappings.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.timestreamwrite.model.MultiMeasureMappings.ReadOnly =
    zio.aws.timestreamwrite.model.MultiMeasureMappings.wrap(buildAwsValue())
}
object MultiMeasureMappings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.MultiMeasureMappings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.MultiMeasureMappings =
      zio.aws.timestreamwrite.model.MultiMeasureMappings(
        targetMultiMeasureName.map(value => value),
        multiMeasureAttributeMappings.map { item =>
          item.asEditable
        }
      )
    def targetMultiMeasureName: Optional[SchemaName]
    def multiMeasureAttributeMappings: List[
      zio.aws.timestreamwrite.model.MultiMeasureAttributeMapping.ReadOnly
    ]
    def getTargetMultiMeasureName: ZIO[Any, AwsError, SchemaName] = AwsError
      .unwrapOptionField("targetMultiMeasureName", targetMultiMeasureName)
    def getMultiMeasureAttributeMappings: ZIO[Any, Nothing, List[
      zio.aws.timestreamwrite.model.MultiMeasureAttributeMapping.ReadOnly
    ]] = ZIO.succeed(multiMeasureAttributeMappings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.MultiMeasureMappings
  ) extends zio.aws.timestreamwrite.model.MultiMeasureMappings.ReadOnly {
    override val targetMultiMeasureName: Optional[SchemaName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetMultiMeasureName())
        .map(value =>
          zio.aws.timestreamwrite.model.primitives.SchemaName(value)
        )
    override val multiMeasureAttributeMappings: List[
      zio.aws.timestreamwrite.model.MultiMeasureAttributeMapping.ReadOnly
    ] = impl
      .multiMeasureAttributeMappings()
      .asScala
      .map { item =>
        zio.aws.timestreamwrite.model.MultiMeasureAttributeMapping.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.MultiMeasureMappings
  ): zio.aws.timestreamwrite.model.MultiMeasureMappings.ReadOnly = new Wrapper(
    impl
  )
}
