package zio.aws.timestreamwrite.model
import scala.jdk.CollectionConverters.*
sealed trait ScalarMeasureValueType {
  def unwrap: software.amazon.awssdk.services.timestreamwrite.model.ScalarMeasureValueType
}
object ScalarMeasureValueType {
  def wrap(
      value: software.amazon.awssdk.services.timestreamwrite.model.ScalarMeasureValueType
  ): zio.aws.timestreamwrite.model.ScalarMeasureValueType = value match {
    case software.amazon.awssdk.services.timestreamwrite.model.ScalarMeasureValueType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.timestreamwrite.model.ScalarMeasureValueType.DOUBLE =>
      val r = DOUBLE
      r
    case software.amazon.awssdk.services.timestreamwrite.model.ScalarMeasureValueType.BIGINT =>
      val r = BIGINT
      r
    case software.amazon.awssdk.services.timestreamwrite.model.ScalarMeasureValueType.BOOLEAN =>
      val r = BOOLEAN
      r
    case software.amazon.awssdk.services.timestreamwrite.model.ScalarMeasureValueType.VARCHAR =>
      val r = VARCHAR
      r
    case software.amazon.awssdk.services.timestreamwrite.model.ScalarMeasureValueType.TIMESTAMP =>
      val r = TIMESTAMP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.timestreamwrite.model.ScalarMeasureValueType {
    override def unwrap
        : software.amazon.awssdk.services.timestreamwrite.model.ScalarMeasureValueType =
      software.amazon.awssdk.services.timestreamwrite.model.ScalarMeasureValueType.UNKNOWN_TO_SDK_VERSION
  }
  case object DOUBLE
      extends zio.aws.timestreamwrite.model.ScalarMeasureValueType {
    override def unwrap
        : software.amazon.awssdk.services.timestreamwrite.model.ScalarMeasureValueType =
      software.amazon.awssdk.services.timestreamwrite.model.ScalarMeasureValueType.DOUBLE
  }
  case object BIGINT
      extends zio.aws.timestreamwrite.model.ScalarMeasureValueType {
    override def unwrap
        : software.amazon.awssdk.services.timestreamwrite.model.ScalarMeasureValueType =
      software.amazon.awssdk.services.timestreamwrite.model.ScalarMeasureValueType.BIGINT
  }
  case object BOOLEAN
      extends zio.aws.timestreamwrite.model.ScalarMeasureValueType {
    override def unwrap
        : software.amazon.awssdk.services.timestreamwrite.model.ScalarMeasureValueType =
      software.amazon.awssdk.services.timestreamwrite.model.ScalarMeasureValueType.BOOLEAN
  }
  case object VARCHAR
      extends zio.aws.timestreamwrite.model.ScalarMeasureValueType {
    override def unwrap
        : software.amazon.awssdk.services.timestreamwrite.model.ScalarMeasureValueType =
      software.amazon.awssdk.services.timestreamwrite.model.ScalarMeasureValueType.VARCHAR
  }
  case object TIMESTAMP
      extends zio.aws.timestreamwrite.model.ScalarMeasureValueType {
    override def unwrap
        : software.amazon.awssdk.services.timestreamwrite.model.ScalarMeasureValueType =
      software.amazon.awssdk.services.timestreamwrite.model.ScalarMeasureValueType.TIMESTAMP
  }
}
