package zio.aws.timestreamwrite.model
import zio.aws.timestreamwrite.model.primitives.BatchLoadTaskId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ResumeBatchLoadTaskRequest(taskId: BatchLoadTaskId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.ResumeBatchLoadTaskRequest = {
    import ResumeBatchLoadTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.ResumeBatchLoadTaskRequest
      .builder()
      .taskId(BatchLoadTaskId.unwrap(taskId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.timestreamwrite.model.ResumeBatchLoadTaskRequest.ReadOnly =
    zio.aws.timestreamwrite.model.ResumeBatchLoadTaskRequest
      .wrap(buildAwsValue())
}
object ResumeBatchLoadTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.ResumeBatchLoadTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.ResumeBatchLoadTaskRequest =
      zio.aws.timestreamwrite.model.ResumeBatchLoadTaskRequest(taskId)
    def taskId: BatchLoadTaskId
    def getTaskId: ZIO[Any, Nothing, BatchLoadTaskId] = ZIO.succeed(taskId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.ResumeBatchLoadTaskRequest
  ) extends zio.aws.timestreamwrite.model.ResumeBatchLoadTaskRequest.ReadOnly {
    override val taskId: BatchLoadTaskId =
      zio.aws.timestreamwrite.model.primitives.BatchLoadTaskId(impl.taskId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.ResumeBatchLoadTaskRequest
  ): zio.aws.timestreamwrite.model.ResumeBatchLoadTaskRequest.ReadOnly =
    new Wrapper(impl)
}
