package zio.aws.timestreamwrite.model
import scala.jdk.CollectionConverters.*
sealed trait TableStatus {
  def unwrap: software.amazon.awssdk.services.timestreamwrite.model.TableStatus
}
object TableStatus {
  def wrap(
      value: software.amazon.awssdk.services.timestreamwrite.model.TableStatus
  ): zio.aws.timestreamwrite.model.TableStatus = value match {
    case software.amazon.awssdk.services.timestreamwrite.model.TableStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.timestreamwrite.model.TableStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.timestreamwrite.model.TableStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.timestreamwrite.model.TableStatus.RESTORING =>
      val r = RESTORING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.timestreamwrite.model.TableStatus {
    override def unwrap
        : software.amazon.awssdk.services.timestreamwrite.model.TableStatus =
      software.amazon.awssdk.services.timestreamwrite.model.TableStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.timestreamwrite.model.TableStatus {
    override def unwrap
        : software.amazon.awssdk.services.timestreamwrite.model.TableStatus =
      software.amazon.awssdk.services.timestreamwrite.model.TableStatus.ACTIVE
  }
  case object DELETING extends zio.aws.timestreamwrite.model.TableStatus {
    override def unwrap
        : software.amazon.awssdk.services.timestreamwrite.model.TableStatus =
      software.amazon.awssdk.services.timestreamwrite.model.TableStatus.DELETING
  }
  case object RESTORING extends zio.aws.timestreamwrite.model.TableStatus {
    override def unwrap
        : software.amazon.awssdk.services.timestreamwrite.model.TableStatus =
      software.amazon.awssdk.services.timestreamwrite.model.TableStatus.RESTORING
  }
}
