package zio.aws.timestreamwrite.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DataModelConfiguration(
    dataModel: Optional[zio.aws.timestreamwrite.model.DataModel] =
      Optional.Absent,
    dataModelS3Configuration: Optional[
      zio.aws.timestreamwrite.model.DataModelS3Configuration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.DataModelConfiguration = {
    import DataModelConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.DataModelConfiguration
      .builder()
      .optionallyWith(dataModel.map(value => value.buildAwsValue()))(
        _.dataModel
      )
      .optionallyWith(
        dataModelS3Configuration.map(value => value.buildAwsValue())
      )(_.dataModelS3Configuration)
      .build()
  }
  def asReadOnly
      : zio.aws.timestreamwrite.model.DataModelConfiguration.ReadOnly =
    zio.aws.timestreamwrite.model.DataModelConfiguration.wrap(buildAwsValue())
}
object DataModelConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.DataModelConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.DataModelConfiguration =
      zio.aws.timestreamwrite.model.DataModelConfiguration(
        dataModel.map(value => value.asEditable),
        dataModelS3Configuration.map(value => value.asEditable)
      )
    def dataModel: Optional[zio.aws.timestreamwrite.model.DataModel.ReadOnly]
    def dataModelS3Configuration: Optional[
      zio.aws.timestreamwrite.model.DataModelS3Configuration.ReadOnly
    ]
    def getDataModel
        : ZIO[Any, AwsError, zio.aws.timestreamwrite.model.DataModel.ReadOnly] =
      AwsError.unwrapOptionField("dataModel", dataModel)
    def getDataModelS3Configuration: ZIO[
      Any,
      AwsError,
      zio.aws.timestreamwrite.model.DataModelS3Configuration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dataModelS3Configuration",
      dataModelS3Configuration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.DataModelConfiguration
  ) extends zio.aws.timestreamwrite.model.DataModelConfiguration.ReadOnly {
    override val dataModel
        : Optional[zio.aws.timestreamwrite.model.DataModel.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataModel())
        .map(value => zio.aws.timestreamwrite.model.DataModel.wrap(value))
    override val dataModelS3Configuration: Optional[
      zio.aws.timestreamwrite.model.DataModelS3Configuration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dataModelS3Configuration())
      .map(value =>
        zio.aws.timestreamwrite.model.DataModelS3Configuration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.DataModelConfiguration
  ): zio.aws.timestreamwrite.model.DataModelConfiguration.ReadOnly =
    new Wrapper(impl)
}
