package zio.aws.timestreamwrite.model
import zio.aws.timestreamwrite.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateTableRequest(
    databaseName: ResourceName,
    tableName: ResourceName,
    retentionProperties: Optional[
      zio.aws.timestreamwrite.model.RetentionProperties
    ] = Optional.Absent,
    magneticStoreWriteProperties: Optional[
      zio.aws.timestreamwrite.model.MagneticStoreWriteProperties
    ] = Optional.Absent,
    schema: Optional[zio.aws.timestreamwrite.model.Schema] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.UpdateTableRequest = {
    import UpdateTableRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.UpdateTableRequest
      .builder()
      .databaseName(ResourceName.unwrap(databaseName): java.lang.String)
      .tableName(ResourceName.unwrap(tableName): java.lang.String)
      .optionallyWith(retentionProperties.map(value => value.buildAwsValue()))(
        _.retentionProperties
      )
      .optionallyWith(
        magneticStoreWriteProperties.map(value => value.buildAwsValue())
      )(_.magneticStoreWriteProperties)
      .optionallyWith(schema.map(value => value.buildAwsValue()))(_.schema)
      .build()
  }
  def asReadOnly: zio.aws.timestreamwrite.model.UpdateTableRequest.ReadOnly =
    zio.aws.timestreamwrite.model.UpdateTableRequest.wrap(buildAwsValue())
}
object UpdateTableRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.UpdateTableRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.UpdateTableRequest =
      zio.aws.timestreamwrite.model.UpdateTableRequest(
        databaseName,
        tableName,
        retentionProperties.map(value => value.asEditable),
        magneticStoreWriteProperties.map(value => value.asEditable),
        schema.map(value => value.asEditable)
      )
    def databaseName: ResourceName
    def tableName: ResourceName
    def retentionProperties
        : Optional[zio.aws.timestreamwrite.model.RetentionProperties.ReadOnly]
    def magneticStoreWriteProperties: Optional[
      zio.aws.timestreamwrite.model.MagneticStoreWriteProperties.ReadOnly
    ]
    def schema: Optional[zio.aws.timestreamwrite.model.Schema.ReadOnly]
    def getDatabaseName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(databaseName)
    def getTableName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(tableName)
    def getRetentionProperties: ZIO[
      Any,
      AwsError,
      zio.aws.timestreamwrite.model.RetentionProperties.ReadOnly
    ] = AwsError.unwrapOptionField("retentionProperties", retentionProperties)
    def getMagneticStoreWriteProperties: ZIO[
      Any,
      AwsError,
      zio.aws.timestreamwrite.model.MagneticStoreWriteProperties.ReadOnly
    ] = AwsError.unwrapOptionField(
      "magneticStoreWriteProperties",
      magneticStoreWriteProperties
    )
    def getSchema
        : ZIO[Any, AwsError, zio.aws.timestreamwrite.model.Schema.ReadOnly] =
      AwsError.unwrapOptionField("schema", schema)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.UpdateTableRequest
  ) extends zio.aws.timestreamwrite.model.UpdateTableRequest.ReadOnly {
    override val databaseName: ResourceName =
      zio.aws.timestreamwrite.model.primitives.ResourceName(impl.databaseName())
    override val tableName: ResourceName =
      zio.aws.timestreamwrite.model.primitives.ResourceName(impl.tableName())
    override val retentionProperties
        : Optional[zio.aws.timestreamwrite.model.RetentionProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retentionProperties())
        .map(value =>
          zio.aws.timestreamwrite.model.RetentionProperties.wrap(value)
        )
    override val magneticStoreWriteProperties: Optional[
      zio.aws.timestreamwrite.model.MagneticStoreWriteProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.magneticStoreWriteProperties())
      .map(value =>
        zio.aws.timestreamwrite.model.MagneticStoreWriteProperties.wrap(value)
      )
    override val schema
        : Optional[zio.aws.timestreamwrite.model.Schema.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schema())
        .map(value => zio.aws.timestreamwrite.model.Schema.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.UpdateTableRequest
  ): zio.aws.timestreamwrite.model.UpdateTableRequest.ReadOnly = new Wrapper(
    impl
  )
}
