package zio.aws.timestreamwrite.model
import zio.aws.timestreamwrite.model.primitives.{S3ObjectKey, S3BucketName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DataSourceS3Configuration(
    bucketName: S3BucketName,
    objectKeyPrefix: Optional[S3ObjectKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.DataSourceS3Configuration = {
    import DataSourceS3Configuration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.DataSourceS3Configuration
      .builder()
      .bucketName(S3BucketName.unwrap(bucketName): java.lang.String)
      .optionallyWith(
        objectKeyPrefix.map(value =>
          S3ObjectKey.unwrap(value): java.lang.String
        )
      )(_.objectKeyPrefix)
      .build()
  }
  def asReadOnly
      : zio.aws.timestreamwrite.model.DataSourceS3Configuration.ReadOnly =
    zio.aws.timestreamwrite.model.DataSourceS3Configuration
      .wrap(buildAwsValue())
}
object DataSourceS3Configuration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.DataSourceS3Configuration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.DataSourceS3Configuration =
      zio.aws.timestreamwrite.model.DataSourceS3Configuration(
        bucketName,
        objectKeyPrefix.map(value => value)
      )
    def bucketName: S3BucketName
    def objectKeyPrefix: Optional[S3ObjectKey]
    def getBucketName: ZIO[Any, Nothing, S3BucketName] = ZIO.succeed(bucketName)
    def getObjectKeyPrefix: ZIO[Any, AwsError, S3ObjectKey] =
      AwsError.unwrapOptionField("objectKeyPrefix", objectKeyPrefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.DataSourceS3Configuration
  ) extends zio.aws.timestreamwrite.model.DataSourceS3Configuration.ReadOnly {
    override val bucketName: S3BucketName =
      zio.aws.timestreamwrite.model.primitives.S3BucketName(impl.bucketName())
    override val objectKeyPrefix: Optional[S3ObjectKey] = zio.aws.core.internal
      .optionalFromNullable(impl.objectKeyPrefix())
      .map(value => zio.aws.timestreamwrite.model.primitives.S3ObjectKey(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.DataSourceS3Configuration
  ): zio.aws.timestreamwrite.model.DataSourceS3Configuration.ReadOnly =
    new Wrapper(impl)
}
