package zio.aws.timestreamwrite.model
import zio.aws.timestreamwrite.model.primitives.BatchLoadTaskId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeBatchLoadTaskRequest(taskId: BatchLoadTaskId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.DescribeBatchLoadTaskRequest = {
    import DescribeBatchLoadTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.DescribeBatchLoadTaskRequest
      .builder()
      .taskId(BatchLoadTaskId.unwrap(taskId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.timestreamwrite.model.DescribeBatchLoadTaskRequest.ReadOnly =
    zio.aws.timestreamwrite.model.DescribeBatchLoadTaskRequest
      .wrap(buildAwsValue())
}
object DescribeBatchLoadTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.DescribeBatchLoadTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.DescribeBatchLoadTaskRequest =
      zio.aws.timestreamwrite.model.DescribeBatchLoadTaskRequest(taskId)
    def taskId: BatchLoadTaskId
    def getTaskId: ZIO[Any, Nothing, BatchLoadTaskId] = ZIO.succeed(taskId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.DescribeBatchLoadTaskRequest
  ) extends zio.aws.timestreamwrite.model.DescribeBatchLoadTaskRequest.ReadOnly {
    override val taskId: BatchLoadTaskId =
      zio.aws.timestreamwrite.model.primitives.BatchLoadTaskId(impl.taskId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.DescribeBatchLoadTaskRequest
  ): zio.aws.timestreamwrite.model.DescribeBatchLoadTaskRequest.ReadOnly =
    new Wrapper(impl)
}
