package zio.aws.timestreamwrite.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.timestreamwrite.model.primitives.{
  Date,
  ResourceName,
  BatchLoadTaskId
}
import scala.jdk.CollectionConverters.*
final case class BatchLoadTask(
    taskId: Optional[BatchLoadTaskId] = Optional.Absent,
    taskStatus: Optional[zio.aws.timestreamwrite.model.BatchLoadStatus] =
      Optional.Absent,
    databaseName: Optional[ResourceName] = Optional.Absent,
    tableName: Optional[ResourceName] = Optional.Absent,
    creationTime: Optional[Date] = Optional.Absent,
    lastUpdatedTime: Optional[Date] = Optional.Absent,
    resumableUntil: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.BatchLoadTask = {
    import BatchLoadTask.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.BatchLoadTask
      .builder()
      .optionallyWith(
        taskId.map(value => BatchLoadTaskId.unwrap(value): java.lang.String)
      )(_.taskId)
      .optionallyWith(taskStatus.map(value => value.unwrap))(_.taskStatus)
      .optionallyWith(
        databaseName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.databaseName)
      .optionallyWith(
        tableName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.tableName)
      .optionallyWith(creationTime.map(value => Date.unwrap(value): Instant))(
        _.creationTime
      )
      .optionallyWith(
        lastUpdatedTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(resumableUntil.map(value => Date.unwrap(value): Instant))(
        _.resumableUntil
      )
      .build()
  }
  def asReadOnly: zio.aws.timestreamwrite.model.BatchLoadTask.ReadOnly =
    zio.aws.timestreamwrite.model.BatchLoadTask.wrap(buildAwsValue())
}
object BatchLoadTask {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.BatchLoadTask
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.BatchLoadTask =
      zio.aws.timestreamwrite.model.BatchLoadTask(
        taskId.map(value => value),
        taskStatus.map(value => value),
        databaseName.map(value => value),
        tableName.map(value => value),
        creationTime.map(value => value),
        lastUpdatedTime.map(value => value),
        resumableUntil.map(value => value)
      )
    def taskId: Optional[BatchLoadTaskId]
    def taskStatus: Optional[zio.aws.timestreamwrite.model.BatchLoadStatus]
    def databaseName: Optional[ResourceName]
    def tableName: Optional[ResourceName]
    def creationTime: Optional[Date]
    def lastUpdatedTime: Optional[Date]
    def resumableUntil: Optional[Date]
    def getTaskId: ZIO[Any, AwsError, BatchLoadTaskId] =
      AwsError.unwrapOptionField("taskId", taskId)
    def getTaskStatus
        : ZIO[Any, AwsError, zio.aws.timestreamwrite.model.BatchLoadStatus] =
      AwsError.unwrapOptionField("taskStatus", taskStatus)
    def getDatabaseName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getTableName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("tableName", tableName)
    def getCreationTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastUpdatedTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getResumableUntil: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("resumableUntil", resumableUntil)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.BatchLoadTask
  ) extends zio.aws.timestreamwrite.model.BatchLoadTask.ReadOnly {
    override val taskId: Optional[BatchLoadTaskId] = zio.aws.core.internal
      .optionalFromNullable(impl.taskId())
      .map(value =>
        zio.aws.timestreamwrite.model.primitives.BatchLoadTaskId(value)
      )
    override val taskStatus
        : Optional[zio.aws.timestreamwrite.model.BatchLoadStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskStatus())
        .map(value => zio.aws.timestreamwrite.model.BatchLoadStatus.wrap(value))
    override val databaseName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseName())
      .map(value =>
        zio.aws.timestreamwrite.model.primitives.ResourceName(value)
      )
    override val tableName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.tableName())
      .map(value =>
        zio.aws.timestreamwrite.model.primitives.ResourceName(value)
      )
    override val creationTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.timestreamwrite.model.primitives.Date(value))
    override val lastUpdatedTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedTime())
      .map(value => zio.aws.timestreamwrite.model.primitives.Date(value))
    override val resumableUntil: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.resumableUntil())
      .map(value => zio.aws.timestreamwrite.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.BatchLoadTask
  ): zio.aws.timestreamwrite.model.BatchLoadTask.ReadOnly = new Wrapper(impl)
}
