package zio.aws.timestreamwrite.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.timestreamwrite.model.primitives.{PaginationLimit, ResourceName}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListTablesRequest(
    databaseName: Optional[ResourceName] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[PaginationLimit] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.ListTablesRequest = {
    import ListTablesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.ListTablesRequest
      .builder()
      .optionallyWith(
        databaseName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.databaseName)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => PaginationLimit.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.timestreamwrite.model.ListTablesRequest.ReadOnly =
    zio.aws.timestreamwrite.model.ListTablesRequest.wrap(buildAwsValue())
}
object ListTablesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.ListTablesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.ListTablesRequest =
      zio.aws.timestreamwrite.model.ListTablesRequest(
        databaseName.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def databaseName: Optional[ResourceName]
    def nextToken: Optional[String]
    def maxResults: Optional[PaginationLimit]
    def getDatabaseName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, PaginationLimit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.ListTablesRequest
  ) extends zio.aws.timestreamwrite.model.ListTablesRequest.ReadOnly {
    override val databaseName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseName())
      .map(value =>
        zio.aws.timestreamwrite.model.primitives.ResourceName(value)
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[PaginationLimit] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.timestreamwrite.model.primitives.PaginationLimit(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.ListTablesRequest
  ): zio.aws.timestreamwrite.model.ListTablesRequest.ReadOnly = new Wrapper(
    impl
  )
}
