package zio.aws.timestreamwrite.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.timestreamwrite.model.primitives.PaginationLimit
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListDatabasesRequest(
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[PaginationLimit] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.ListDatabasesRequest = {
    import ListDatabasesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.ListDatabasesRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => PaginationLimit.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.timestreamwrite.model.ListDatabasesRequest.ReadOnly =
    zio.aws.timestreamwrite.model.ListDatabasesRequest.wrap(buildAwsValue())
}
object ListDatabasesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.ListDatabasesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.ListDatabasesRequest =
      zio.aws.timestreamwrite.model.ListDatabasesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[String]
    def maxResults: Optional[PaginationLimit]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, PaginationLimit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.ListDatabasesRequest
  ) extends zio.aws.timestreamwrite.model.ListDatabasesRequest.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[PaginationLimit] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.timestreamwrite.model.primitives.PaginationLimit(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.ListDatabasesRequest
  ): zio.aws.timestreamwrite.model.ListDatabasesRequest.ReadOnly = new Wrapper(
    impl
  )
}
