package zio.aws.timestreamwrite.model
import scala.jdk.CollectionConverters.*
sealed trait MeasureValueType {
  def unwrap
      : software.amazon.awssdk.services.timestreamwrite.model.MeasureValueType
}
object MeasureValueType {
  def wrap(
      value: software.amazon.awssdk.services.timestreamwrite.model.MeasureValueType
  ): zio.aws.timestreamwrite.model.MeasureValueType = value match {
    case software.amazon.awssdk.services.timestreamwrite.model.MeasureValueType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.timestreamwrite.model.MeasureValueType.DOUBLE =>
      val r = DOUBLE
      r
    case software.amazon.awssdk.services.timestreamwrite.model.MeasureValueType.BIGINT =>
      val r = BIGINT
      r
    case software.amazon.awssdk.services.timestreamwrite.model.MeasureValueType.VARCHAR =>
      val r = VARCHAR
      r
    case software.amazon.awssdk.services.timestreamwrite.model.MeasureValueType.BOOLEAN =>
      val r = BOOLEAN
      r
    case software.amazon.awssdk.services.timestreamwrite.model.MeasureValueType.TIMESTAMP =>
      val r = TIMESTAMP
      r
    case software.amazon.awssdk.services.timestreamwrite.model.MeasureValueType.MULTI =>
      val r = MULTI
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.timestreamwrite.model.MeasureValueType {
    override def unwrap
        : software.amazon.awssdk.services.timestreamwrite.model.MeasureValueType =
      software.amazon.awssdk.services.timestreamwrite.model.MeasureValueType.UNKNOWN_TO_SDK_VERSION
  }
  case object DOUBLE extends zio.aws.timestreamwrite.model.MeasureValueType {
    override def unwrap
        : software.amazon.awssdk.services.timestreamwrite.model.MeasureValueType =
      software.amazon.awssdk.services.timestreamwrite.model.MeasureValueType.DOUBLE
  }
  case object BIGINT extends zio.aws.timestreamwrite.model.MeasureValueType {
    override def unwrap
        : software.amazon.awssdk.services.timestreamwrite.model.MeasureValueType =
      software.amazon.awssdk.services.timestreamwrite.model.MeasureValueType.BIGINT
  }
  case object VARCHAR extends zio.aws.timestreamwrite.model.MeasureValueType {
    override def unwrap
        : software.amazon.awssdk.services.timestreamwrite.model.MeasureValueType =
      software.amazon.awssdk.services.timestreamwrite.model.MeasureValueType.VARCHAR
  }
  case object BOOLEAN extends zio.aws.timestreamwrite.model.MeasureValueType {
    override def unwrap
        : software.amazon.awssdk.services.timestreamwrite.model.MeasureValueType =
      software.amazon.awssdk.services.timestreamwrite.model.MeasureValueType.BOOLEAN
  }
  case object TIMESTAMP extends zio.aws.timestreamwrite.model.MeasureValueType {
    override def unwrap
        : software.amazon.awssdk.services.timestreamwrite.model.MeasureValueType =
      software.amazon.awssdk.services.timestreamwrite.model.MeasureValueType.TIMESTAMP
  }
  case object MULTI extends zio.aws.timestreamwrite.model.MeasureValueType {
    override def unwrap
        : software.amazon.awssdk.services.timestreamwrite.model.MeasureValueType =
      software.amazon.awssdk.services.timestreamwrite.model.MeasureValueType.MULTI
  }
}
