package zio.aws.timestreamwrite.model
import zio.aws.timestreamwrite.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RecordsIngested(
    total: Optional[Integer] = Optional.Absent,
    memoryStore: Optional[Integer] = Optional.Absent,
    magneticStore: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.RecordsIngested = {
    import RecordsIngested.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.RecordsIngested
      .builder()
      .optionallyWith(total.map(value => value: java.lang.Integer))(_.total)
      .optionallyWith(memoryStore.map(value => value: java.lang.Integer))(
        _.memoryStore
      )
      .optionallyWith(magneticStore.map(value => value: java.lang.Integer))(
        _.magneticStore
      )
      .build()
  }
  def asReadOnly: zio.aws.timestreamwrite.model.RecordsIngested.ReadOnly =
    zio.aws.timestreamwrite.model.RecordsIngested.wrap(buildAwsValue())
}
object RecordsIngested {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.RecordsIngested
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.RecordsIngested =
      zio.aws.timestreamwrite.model.RecordsIngested(
        total.map(value => value),
        memoryStore.map(value => value),
        magneticStore.map(value => value)
      )
    def total: Optional[Integer]
    def memoryStore: Optional[Integer]
    def magneticStore: Optional[Integer]
    def getTotal: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("total", total)
    def getMemoryStore: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("memoryStore", memoryStore)
    def getMagneticStore: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("magneticStore", magneticStore)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.RecordsIngested
  ) extends zio.aws.timestreamwrite.model.RecordsIngested.ReadOnly {
    override val total: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.total())
      .map(value => value: Integer)
    override val memoryStore: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.memoryStore())
      .map(value => value: Integer)
    override val magneticStore: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.magneticStore())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.RecordsIngested
  ): zio.aws.timestreamwrite.model.RecordsIngested.ReadOnly = new Wrapper(impl)
}
