package zio.aws.timestreamwrite.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MagneticStoreWriteProperties(
    enableMagneticStoreWrites: Boolean,
    magneticStoreRejectedDataLocation: Optional[
      zio.aws.timestreamwrite.model.MagneticStoreRejectedDataLocation
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.MagneticStoreWriteProperties = {
    import MagneticStoreWriteProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.MagneticStoreWriteProperties
      .builder()
      .enableMagneticStoreWrites(enableMagneticStoreWrites: java.lang.Boolean)
      .optionallyWith(
        magneticStoreRejectedDataLocation.map(value => value.buildAwsValue())
      )(_.magneticStoreRejectedDataLocation)
      .build()
  }
  def asReadOnly
      : zio.aws.timestreamwrite.model.MagneticStoreWriteProperties.ReadOnly =
    zio.aws.timestreamwrite.model.MagneticStoreWriteProperties
      .wrap(buildAwsValue())
}
object MagneticStoreWriteProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.MagneticStoreWriteProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.MagneticStoreWriteProperties =
      zio.aws.timestreamwrite.model.MagneticStoreWriteProperties(
        enableMagneticStoreWrites,
        magneticStoreRejectedDataLocation.map(value => value.asEditable)
      )
    def enableMagneticStoreWrites: Boolean
    def magneticStoreRejectedDataLocation: Optional[
      zio.aws.timestreamwrite.model.MagneticStoreRejectedDataLocation.ReadOnly
    ]
    def getEnableMagneticStoreWrites: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(enableMagneticStoreWrites)
    def getMagneticStoreRejectedDataLocation: ZIO[
      Any,
      AwsError,
      zio.aws.timestreamwrite.model.MagneticStoreRejectedDataLocation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "magneticStoreRejectedDataLocation",
      magneticStoreRejectedDataLocation
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.MagneticStoreWriteProperties
  ) extends zio.aws.timestreamwrite.model.MagneticStoreWriteProperties.ReadOnly {
    override val enableMagneticStoreWrites: Boolean =
      impl.enableMagneticStoreWrites(): Boolean
    override val magneticStoreRejectedDataLocation: Optional[
      zio.aws.timestreamwrite.model.MagneticStoreRejectedDataLocation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.magneticStoreRejectedDataLocation())
      .map(value =>
        zio.aws.timestreamwrite.model.MagneticStoreRejectedDataLocation
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.MagneticStoreWriteProperties
  ): zio.aws.timestreamwrite.model.MagneticStoreWriteProperties.ReadOnly =
    new Wrapper(impl)
}
