package zio.aws.timestreamwrite.model
import zio.aws.timestreamwrite.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class WriteRecordsRequest(
    databaseName: ResourceName,
    tableName: ResourceName,
    commonAttributes: Option[zio.aws.timestreamwrite.model.Record] = None,
    records: Iterable[zio.aws.timestreamwrite.model.Record]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.WriteRecordsRequest = {
    import WriteRecordsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.WriteRecordsRequest
      .builder()
      .databaseName(ResourceName.unwrap(databaseName): java.lang.String)
      .tableName(ResourceName.unwrap(tableName): java.lang.String)
      .optionallyWith(commonAttributes.map(value => value.buildAwsValue()))(
        _.commonAttributes
      )
      .records(records.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.timestreamwrite.model.WriteRecordsRequest.ReadOnly =
    zio.aws.timestreamwrite.model.WriteRecordsRequest.wrap(buildAwsValue())
}
object WriteRecordsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.WriteRecordsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.WriteRecordsRequest =
      zio.aws.timestreamwrite.model.WriteRecordsRequest(
        databaseName,
        tableName,
        commonAttributes.map(value => value.asEditable),
        records.map { item =>
          item.asEditable
        }
      )
    def databaseName: ResourceName
    def tableName: ResourceName
    def commonAttributes: Option[zio.aws.timestreamwrite.model.Record.ReadOnly]
    def records: List[zio.aws.timestreamwrite.model.Record.ReadOnly]
    def getDatabaseName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(databaseName)
    def getTableName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(tableName)
    def getCommonAttributes
        : ZIO[Any, AwsError, zio.aws.timestreamwrite.model.Record.ReadOnly] =
      AwsError.unwrapOptionField("commonAttributes", commonAttributes)
    def getRecords: ZIO[Any, Nothing, List[
      zio.aws.timestreamwrite.model.Record.ReadOnly
    ]] = ZIO.succeed(records)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.WriteRecordsRequest
  ) extends zio.aws.timestreamwrite.model.WriteRecordsRequest.ReadOnly {
    override val databaseName: ResourceName =
      zio.aws.timestreamwrite.model.primitives.ResourceName(impl.databaseName())
    override val tableName: ResourceName =
      zio.aws.timestreamwrite.model.primitives.ResourceName(impl.tableName())
    override val commonAttributes
        : Option[zio.aws.timestreamwrite.model.Record.ReadOnly] = scala
      .Option(impl.commonAttributes())
      .map(value => zio.aws.timestreamwrite.model.Record.wrap(value))
    override val records: List[zio.aws.timestreamwrite.model.Record.ReadOnly] =
      impl
        .records()
        .asScala
        .map { item =>
          zio.aws.timestreamwrite.model.Record.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.WriteRecordsRequest
  ): zio.aws.timestreamwrite.model.WriteRecordsRequest.ReadOnly = new Wrapper(
    impl
  )
}
