package zio.aws.timestreamwrite.model
import zio.aws.timestreamwrite.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeTableRequest(
    databaseName: ResourceName,
    tableName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.DescribeTableRequest = {
    import DescribeTableRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.DescribeTableRequest
      .builder()
      .databaseName(ResourceName.unwrap(databaseName): java.lang.String)
      .tableName(ResourceName.unwrap(tableName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.timestreamwrite.model.DescribeTableRequest.ReadOnly =
    zio.aws.timestreamwrite.model.DescribeTableRequest.wrap(buildAwsValue())
}
object DescribeTableRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.DescribeTableRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.DescribeTableRequest =
      zio.aws.timestreamwrite.model
        .DescribeTableRequest(databaseName, tableName)
    def databaseName: ResourceName
    def tableName: ResourceName
    def getDatabaseName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(databaseName)
    def getTableName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(tableName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.DescribeTableRequest
  ) extends zio.aws.timestreamwrite.model.DescribeTableRequest.ReadOnly {
    override val databaseName: ResourceName =
      zio.aws.timestreamwrite.model.primitives.ResourceName(impl.databaseName())
    override val tableName: ResourceName =
      zio.aws.timestreamwrite.model.primitives.ResourceName(impl.tableName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.DescribeTableRequest
  ): zio.aws.timestreamwrite.model.DescribeTableRequest.ReadOnly = new Wrapper(
    impl
  )
}
