package zio.aws.timestreamwrite
import zio.aws.timestreamwrite.model.CreateTableResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.timestreamwrite.model.{
  CreateDatabaseResponse,
  UpdateDatabaseResponse,
  UpdateTableResponse,
  DescribeDatabaseResponse,
  CreateDatabaseRequest,
  DescribeEndpointsRequest,
  DeleteDatabaseResponse,
  DescribeTableRequest,
  WriteRecordsResponse,
  DescribeDatabaseRequest,
  ListDatabasesResponse,
  Table,
  ListTagsForResourceRequest,
  UpdateTableRequest,
  ListDatabasesRequest,
  CreateTableRequest,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  DescribeEndpointsResponse,
  Database,
  UntagResourceRequest,
  DescribeTableResponse,
  DeleteTableRequest,
  UpdateDatabaseRequest,
  ListTablesResponse,
  WriteRecordsRequest,
  TagResourceResponse,
  ListTablesRequest,
  DeleteDatabaseRequest,
  DeleteTableResponse,
  TagResourceRequest,
  CreateTableResponse
}
import zio.stream.ZStream
import software.amazon.awssdk.services.timestreamwrite.{
  TimestreamWriteAsyncClientBuilder,
  TimestreamWriteAsyncClient
}
import scala.jdk.CollectionConverters.*
trait TimestreamWrite extends AspectSupport[TimestreamWrite] {
  val api: TimestreamWriteAsyncClient
  def listDatabases(
      request: zio.aws.timestreamwrite.model.ListDatabasesRequest
  ): ZStream[Any, AwsError, zio.aws.timestreamwrite.model.Database.ReadOnly]
  def listDatabasesPaginated(
      request: zio.aws.timestreamwrite.model.ListDatabasesRequest
  ): IO[AwsError, zio.aws.timestreamwrite.model.ListDatabasesResponse.ReadOnly]
  def createTable(
      request: zio.aws.timestreamwrite.model.CreateTableRequest
  ): IO[AwsError, ReadOnly]
  def deleteTable(
      request: zio.aws.timestreamwrite.model.DeleteTableRequest
  ): IO[AwsError, Unit]
  def createDatabase(
      request: zio.aws.timestreamwrite.model.CreateDatabaseRequest
  ): IO[AwsError, zio.aws.timestreamwrite.model.CreateDatabaseResponse.ReadOnly]
  def describeDatabase(
      request: zio.aws.timestreamwrite.model.DescribeDatabaseRequest
  ): IO[
    AwsError,
    zio.aws.timestreamwrite.model.DescribeDatabaseResponse.ReadOnly
  ]
  def listTables(
      request: zio.aws.timestreamwrite.model.ListTablesRequest
  ): ZStream[Any, AwsError, zio.aws.timestreamwrite.model.Table.ReadOnly]
  def listTablesPaginated(
      request: zio.aws.timestreamwrite.model.ListTablesRequest
  ): IO[AwsError, zio.aws.timestreamwrite.model.ListTablesResponse.ReadOnly]
  def describeTable(
      request: zio.aws.timestreamwrite.model.DescribeTableRequest
  ): IO[AwsError, zio.aws.timestreamwrite.model.DescribeTableResponse.ReadOnly]
  def updateTable(
      request: zio.aws.timestreamwrite.model.UpdateTableRequest
  ): IO[AwsError, zio.aws.timestreamwrite.model.UpdateTableResponse.ReadOnly]
  def untagResource(
      request: zio.aws.timestreamwrite.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.timestreamwrite.model.UntagResourceResponse.ReadOnly]
  def deleteDatabase(
      request: zio.aws.timestreamwrite.model.DeleteDatabaseRequest
  ): IO[AwsError, Unit]
  def describeEndpoints(
      request: zio.aws.timestreamwrite.model.DescribeEndpointsRequest
  ): IO[
    AwsError,
    zio.aws.timestreamwrite.model.DescribeEndpointsResponse.ReadOnly
  ]
  def listTagsForResource(
      request: zio.aws.timestreamwrite.model.ListTagsForResourceRequest
  ): IO[
    AwsError,
    zio.aws.timestreamwrite.model.ListTagsForResourceResponse.ReadOnly
  ]
  def tagResource(
      request: zio.aws.timestreamwrite.model.TagResourceRequest
  ): IO[AwsError, zio.aws.timestreamwrite.model.TagResourceResponse.ReadOnly]
  def updateDatabase(
      request: zio.aws.timestreamwrite.model.UpdateDatabaseRequest
  ): IO[AwsError, zio.aws.timestreamwrite.model.UpdateDatabaseResponse.ReadOnly]
  def writeRecords(
      request: zio.aws.timestreamwrite.model.WriteRecordsRequest
  ): IO[AwsError, zio.aws.timestreamwrite.model.WriteRecordsResponse.ReadOnly]
}
object TimestreamWrite {
  val live: ZLayer[AwsConfig, java.lang.Throwable, TimestreamWrite] =
    customized(identity)
  def customized(
      customization: TimestreamWriteAsyncClientBuilder => TimestreamWriteAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, TimestreamWrite] = managed(
    customization
  ).toLayer
  def managed(
      customization: TimestreamWriteAsyncClientBuilder => TimestreamWriteAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, TimestreamWrite] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = TimestreamWriteAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[TimestreamWriteAsyncClient, TimestreamWriteAsyncClientBuilder](
        builder
      )
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        TimestreamWriteAsyncClient,
        TimestreamWriteAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new TimestreamWriteImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class TimestreamWriteImpl[R](
      override val api: TimestreamWriteAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends TimestreamWrite
      with AwsServiceBase[R] {
    override val serviceName: String = "TimestreamWrite"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): TimestreamWriteImpl[R1] = new TimestreamWriteImpl(api, newAspect, r)
    def listDatabases(
        request: zio.aws.timestreamwrite.model.ListDatabasesRequest
    ): ZStream[Any, AwsError, zio.aws.timestreamwrite.model.Database.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListDatabasesRequest,
        ListDatabasesResponse,
        Database
      ](
        "listDatabases",
        api.listDatabases,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.databases().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.timestreamwrite.model.Database.wrap(item))
        .provideEnvironment(r)
    def listDatabasesPaginated(
        request: zio.aws.timestreamwrite.model.ListDatabasesRequest
    ): IO[
      AwsError,
      zio.aws.timestreamwrite.model.ListDatabasesResponse.ReadOnly
    ] = asyncRequestResponse[ListDatabasesRequest, ListDatabasesResponse](
      "listDatabases",
      api.listDatabases
    )(request.buildAwsValue())
      .map(zio.aws.timestreamwrite.model.ListDatabasesResponse.wrap)
      .provideEnvironment(r)
    def createTable(
        request: zio.aws.timestreamwrite.model.CreateTableRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[CreateTableRequest, CreateTableResponse](
        "createTable",
        api.createTable
      )(request.buildAwsValue())
        .map(zio.aws.timestreamwrite.model.CreateTableResponse.wrap)
        .provideEnvironment(r)
    def deleteTable(
        request: zio.aws.timestreamwrite.model.DeleteTableRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteTableRequest, DeleteTableResponse](
        "deleteTable",
        api.deleteTable
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def createDatabase(
        request: zio.aws.timestreamwrite.model.CreateDatabaseRequest
    ): IO[
      AwsError,
      zio.aws.timestreamwrite.model.CreateDatabaseResponse.ReadOnly
    ] = asyncRequestResponse[CreateDatabaseRequest, CreateDatabaseResponse](
      "createDatabase",
      api.createDatabase
    )(request.buildAwsValue())
      .map(zio.aws.timestreamwrite.model.CreateDatabaseResponse.wrap)
      .provideEnvironment(r)
    def describeDatabase(
        request: zio.aws.timestreamwrite.model.DescribeDatabaseRequest
    ): IO[
      AwsError,
      zio.aws.timestreamwrite.model.DescribeDatabaseResponse.ReadOnly
    ] = asyncRequestResponse[DescribeDatabaseRequest, DescribeDatabaseResponse](
      "describeDatabase",
      api.describeDatabase
    )(request.buildAwsValue())
      .map(zio.aws.timestreamwrite.model.DescribeDatabaseResponse.wrap)
      .provideEnvironment(r)
    def listTables(
        request: zio.aws.timestreamwrite.model.ListTablesRequest
    ): ZStream[Any, AwsError, zio.aws.timestreamwrite.model.Table.ReadOnly] =
      asyncSimplePaginatedRequest[ListTablesRequest, ListTablesResponse, Table](
        "listTables",
        api.listTables,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.tables().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.timestreamwrite.model.Table.wrap(item))
        .provideEnvironment(r)
    def listTablesPaginated(
        request: zio.aws.timestreamwrite.model.ListTablesRequest
    ): IO[AwsError, zio.aws.timestreamwrite.model.ListTablesResponse.ReadOnly] =
      asyncRequestResponse[ListTablesRequest, ListTablesResponse](
        "listTables",
        api.listTables
      )(request.buildAwsValue())
        .map(zio.aws.timestreamwrite.model.ListTablesResponse.wrap)
        .provideEnvironment(r)
    def describeTable(
        request: zio.aws.timestreamwrite.model.DescribeTableRequest
    ): IO[
      AwsError,
      zio.aws.timestreamwrite.model.DescribeTableResponse.ReadOnly
    ] = asyncRequestResponse[DescribeTableRequest, DescribeTableResponse](
      "describeTable",
      api.describeTable
    )(request.buildAwsValue())
      .map(zio.aws.timestreamwrite.model.DescribeTableResponse.wrap)
      .provideEnvironment(r)
    def updateTable(
        request: zio.aws.timestreamwrite.model.UpdateTableRequest
    ): IO[
      AwsError,
      zio.aws.timestreamwrite.model.UpdateTableResponse.ReadOnly
    ] = asyncRequestResponse[UpdateTableRequest, UpdateTableResponse](
      "updateTable",
      api.updateTable
    )(request.buildAwsValue())
      .map(zio.aws.timestreamwrite.model.UpdateTableResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: zio.aws.timestreamwrite.model.UntagResourceRequest
    ): IO[
      AwsError,
      zio.aws.timestreamwrite.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
      "untagResource",
      api.untagResource
    )(request.buildAwsValue())
      .map(zio.aws.timestreamwrite.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def deleteDatabase(
        request: zio.aws.timestreamwrite.model.DeleteDatabaseRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteDatabaseRequest, DeleteDatabaseResponse](
        "deleteDatabase",
        api.deleteDatabase
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def describeEndpoints(
        request: zio.aws.timestreamwrite.model.DescribeEndpointsRequest
    ): IO[
      AwsError,
      zio.aws.timestreamwrite.model.DescribeEndpointsResponse.ReadOnly
    ] =
      asyncRequestResponse[DescribeEndpointsRequest, DescribeEndpointsResponse](
        "describeEndpoints",
        api.describeEndpoints
      )(request.buildAwsValue())
        .map(zio.aws.timestreamwrite.model.DescribeEndpointsResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.timestreamwrite.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.timestreamwrite.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.timestreamwrite.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: zio.aws.timestreamwrite.model.TagResourceRequest
    ): IO[
      AwsError,
      zio.aws.timestreamwrite.model.TagResourceResponse.ReadOnly
    ] = asyncRequestResponse[TagResourceRequest, TagResourceResponse](
      "tagResource",
      api.tagResource
    )(request.buildAwsValue())
      .map(zio.aws.timestreamwrite.model.TagResourceResponse.wrap)
      .provideEnvironment(r)
    def updateDatabase(
        request: zio.aws.timestreamwrite.model.UpdateDatabaseRequest
    ): IO[
      AwsError,
      zio.aws.timestreamwrite.model.UpdateDatabaseResponse.ReadOnly
    ] = asyncRequestResponse[UpdateDatabaseRequest, UpdateDatabaseResponse](
      "updateDatabase",
      api.updateDatabase
    )(request.buildAwsValue())
      .map(zio.aws.timestreamwrite.model.UpdateDatabaseResponse.wrap)
      .provideEnvironment(r)
    def writeRecords(
        request: zio.aws.timestreamwrite.model.WriteRecordsRequest
    ): IO[
      AwsError,
      zio.aws.timestreamwrite.model.WriteRecordsResponse.ReadOnly
    ] = asyncRequestResponse[WriteRecordsRequest, WriteRecordsResponse](
      "writeRecords",
      api.writeRecords
    )(request.buildAwsValue())
      .map(zio.aws.timestreamwrite.model.WriteRecordsResponse.wrap)
      .provideEnvironment(r)
  }
  def listDatabases(
      request: zio.aws.timestreamwrite.model.ListDatabasesRequest
  ): ZStream[
    zio.aws.timestreamwrite.TimestreamWrite,
    AwsError,
    zio.aws.timestreamwrite.model.Database.ReadOnly
  ] = ZStream.serviceWithStream(_.listDatabases(request))
  def listDatabasesPaginated(
      request: zio.aws.timestreamwrite.model.ListDatabasesRequest
  ): ZIO[
    zio.aws.timestreamwrite.TimestreamWrite,
    AwsError,
    zio.aws.timestreamwrite.model.ListDatabasesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDatabasesPaginated(request))
  def createTable(
      request: zio.aws.timestreamwrite.model.CreateTableRequest
  ): ZIO[zio.aws.timestreamwrite.TimestreamWrite, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.createTable(request))
  def deleteTable(
      request: zio.aws.timestreamwrite.model.DeleteTableRequest
  ): ZIO[zio.aws.timestreamwrite.TimestreamWrite, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteTable(request))
  def createDatabase(
      request: zio.aws.timestreamwrite.model.CreateDatabaseRequest
  ): ZIO[
    zio.aws.timestreamwrite.TimestreamWrite,
    AwsError,
    zio.aws.timestreamwrite.model.CreateDatabaseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDatabase(request))
  def describeDatabase(
      request: zio.aws.timestreamwrite.model.DescribeDatabaseRequest
  ): ZIO[
    zio.aws.timestreamwrite.TimestreamWrite,
    AwsError,
    zio.aws.timestreamwrite.model.DescribeDatabaseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDatabase(request))
  def listTables(
      request: zio.aws.timestreamwrite.model.ListTablesRequest
  ): ZStream[
    zio.aws.timestreamwrite.TimestreamWrite,
    AwsError,
    zio.aws.timestreamwrite.model.Table.ReadOnly
  ] = ZStream.serviceWithStream(_.listTables(request))
  def listTablesPaginated(
      request: zio.aws.timestreamwrite.model.ListTablesRequest
  ): ZIO[
    zio.aws.timestreamwrite.TimestreamWrite,
    AwsError,
    zio.aws.timestreamwrite.model.ListTablesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTablesPaginated(request))
  def describeTable(
      request: zio.aws.timestreamwrite.model.DescribeTableRequest
  ): ZIO[
    zio.aws.timestreamwrite.TimestreamWrite,
    AwsError,
    zio.aws.timestreamwrite.model.DescribeTableResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTable(request))
  def updateTable(
      request: zio.aws.timestreamwrite.model.UpdateTableRequest
  ): ZIO[
    zio.aws.timestreamwrite.TimestreamWrite,
    AwsError,
    zio.aws.timestreamwrite.model.UpdateTableResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateTable(request))
  def untagResource(
      request: zio.aws.timestreamwrite.model.UntagResourceRequest
  ): ZIO[
    zio.aws.timestreamwrite.TimestreamWrite,
    AwsError,
    zio.aws.timestreamwrite.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def deleteDatabase(
      request: zio.aws.timestreamwrite.model.DeleteDatabaseRequest
  ): ZIO[zio.aws.timestreamwrite.TimestreamWrite, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteDatabase(request))
  def describeEndpoints(
      request: zio.aws.timestreamwrite.model.DescribeEndpointsRequest
  ): ZIO[
    zio.aws.timestreamwrite.TimestreamWrite,
    AwsError,
    zio.aws.timestreamwrite.model.DescribeEndpointsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEndpoints(request))
  def listTagsForResource(
      request: zio.aws.timestreamwrite.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.timestreamwrite.TimestreamWrite,
    AwsError,
    zio.aws.timestreamwrite.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(
      request: zio.aws.timestreamwrite.model.TagResourceRequest
  ): ZIO[
    zio.aws.timestreamwrite.TimestreamWrite,
    AwsError,
    zio.aws.timestreamwrite.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def updateDatabase(
      request: zio.aws.timestreamwrite.model.UpdateDatabaseRequest
  ): ZIO[
    zio.aws.timestreamwrite.TimestreamWrite,
    AwsError,
    zio.aws.timestreamwrite.model.UpdateDatabaseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDatabase(request))
  def writeRecords(
      request: zio.aws.timestreamwrite.model.WriteRecordsRequest
  ): ZIO[
    zio.aws.timestreamwrite.TimestreamWrite,
    AwsError,
    zio.aws.timestreamwrite.model.WriteRecordsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.writeRecords(request))
}
