package zio.aws.timestreamwrite.model
import java.lang.Integer
import zio.aws.timestreamwrite.model.primitives.PaginationLimit
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListDatabasesRequest(
    nextToken: Option[String] = None,
    maxResults: Option[PaginationLimit] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.ListDatabasesRequest = {
    import ListDatabasesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.ListDatabasesRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => PaginationLimit.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.timestreamwrite.model.ListDatabasesRequest.ReadOnly =
    zio.aws.timestreamwrite.model.ListDatabasesRequest.wrap(buildAwsValue())
}
object ListDatabasesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.ListDatabasesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.ListDatabasesRequest =
      zio.aws.timestreamwrite.model.ListDatabasesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Option[String]
    def maxResults: Option[PaginationLimit]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, PaginationLimit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.ListDatabasesRequest
  ) extends zio.aws.timestreamwrite.model.ListDatabasesRequest.ReadOnly {
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[PaginationLimit] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.timestreamwrite.model.primitives.PaginationLimit(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.ListDatabasesRequest
  ): zio.aws.timestreamwrite.model.ListDatabasesRequest.ReadOnly = new Wrapper(
    impl
  )
}
