package zio.aws.timestreamwrite.model
import zio.aws.timestreamwrite.model.primitives.{Date, ResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Table(
    arn: Option[String] = None,
    tableName: Option[ResourceName] = None,
    databaseName: Option[ResourceName] = None,
    tableStatus: Option[zio.aws.timestreamwrite.model.TableStatus] = None,
    retentionProperties: Option[
      zio.aws.timestreamwrite.model.RetentionProperties
    ] = None,
    creationTime: Option[Date] = None,
    lastUpdatedTime: Option[Date] = None,
    magneticStoreWriteProperties: Option[
      zio.aws.timestreamwrite.model.MagneticStoreWriteProperties
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.Table = {
    import Table.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.Table
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(
        tableName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.tableName)
      .optionallyWith(
        databaseName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.databaseName)
      .optionallyWith(tableStatus.map(value => value.unwrap))(_.tableStatus)
      .optionallyWith(retentionProperties.map(value => value.buildAwsValue()))(
        _.retentionProperties
      )
      .optionallyWith(creationTime.map(value => Date.unwrap(value): Instant))(
        _.creationTime
      )
      .optionallyWith(
        lastUpdatedTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(
        magneticStoreWriteProperties.map(value => value.buildAwsValue())
      )(_.magneticStoreWriteProperties)
      .build()
  }
  def asReadOnly: zio.aws.timestreamwrite.model.Table.ReadOnly =
    zio.aws.timestreamwrite.model.Table.wrap(buildAwsValue())
}
object Table {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.Table
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.Table =
      zio.aws.timestreamwrite.model.Table(
        arn.map(value => value),
        tableName.map(value => value),
        databaseName.map(value => value),
        tableStatus.map(value => value),
        retentionProperties.map(value => value.asEditable),
        creationTime.map(value => value),
        lastUpdatedTime.map(value => value),
        magneticStoreWriteProperties.map(value => value.asEditable)
      )
    def arn: Option[String]
    def tableName: Option[ResourceName]
    def databaseName: Option[ResourceName]
    def tableStatus: Option[zio.aws.timestreamwrite.model.TableStatus]
    def retentionProperties
        : Option[zio.aws.timestreamwrite.model.RetentionProperties.ReadOnly]
    def creationTime: Option[Date]
    def lastUpdatedTime: Option[Date]
    def magneticStoreWriteProperties: Option[
      zio.aws.timestreamwrite.model.MagneticStoreWriteProperties.ReadOnly
    ]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getTableName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("tableName", tableName)
    def getDatabaseName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getTableStatus
        : ZIO[Any, AwsError, zio.aws.timestreamwrite.model.TableStatus] =
      AwsError.unwrapOptionField("tableStatus", tableStatus)
    def getRetentionProperties: ZIO[
      Any,
      AwsError,
      zio.aws.timestreamwrite.model.RetentionProperties.ReadOnly
    ] = AwsError.unwrapOptionField("retentionProperties", retentionProperties)
    def getCreationTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastUpdatedTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getMagneticStoreWriteProperties: ZIO[
      Any,
      AwsError,
      zio.aws.timestreamwrite.model.MagneticStoreWriteProperties.ReadOnly
    ] = AwsError.unwrapOptionField(
      "magneticStoreWriteProperties",
      magneticStoreWriteProperties
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.Table
  ) extends zio.aws.timestreamwrite.model.Table.ReadOnly {
    override val arn: Option[String] =
      scala.Option(impl.arn()).map(value => value: String)
    override val tableName: Option[ResourceName] = scala
      .Option(impl.tableName())
      .map(value =>
        zio.aws.timestreamwrite.model.primitives.ResourceName(value)
      )
    override val databaseName: Option[ResourceName] = scala
      .Option(impl.databaseName())
      .map(value =>
        zio.aws.timestreamwrite.model.primitives.ResourceName(value)
      )
    override val tableStatus
        : Option[zio.aws.timestreamwrite.model.TableStatus] = scala
      .Option(impl.tableStatus())
      .map(value => zio.aws.timestreamwrite.model.TableStatus.wrap(value))
    override val retentionProperties
        : Option[zio.aws.timestreamwrite.model.RetentionProperties.ReadOnly] =
      scala
        .Option(impl.retentionProperties())
        .map(value =>
          zio.aws.timestreamwrite.model.RetentionProperties.wrap(value)
        )
    override val creationTime: Option[Date] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.timestreamwrite.model.primitives.Date(value))
    override val lastUpdatedTime: Option[Date] = scala
      .Option(impl.lastUpdatedTime())
      .map(value => zio.aws.timestreamwrite.model.primitives.Date(value))
    override val magneticStoreWriteProperties: Option[
      zio.aws.timestreamwrite.model.MagneticStoreWriteProperties.ReadOnly
    ] = scala
      .Option(impl.magneticStoreWriteProperties())
      .map(value =>
        zio.aws.timestreamwrite.model.MagneticStoreWriteProperties.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.Table
  ): zio.aws.timestreamwrite.model.Table.ReadOnly = new Wrapper(impl)
}
