package zio.aws.timestreamwrite.model
import zio.aws.timestreamwrite.model.primitives.ResourceCreateAPIName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateTableRequest(
    databaseName: ResourceCreateAPIName,
    tableName: ResourceCreateAPIName,
    retentionProperties: Option[
      zio.aws.timestreamwrite.model.RetentionProperties
    ] = None,
    tags: Option[Iterable[zio.aws.timestreamwrite.model.Tag]] = None,
    magneticStoreWriteProperties: Option[
      zio.aws.timestreamwrite.model.MagneticStoreWriteProperties
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.CreateTableRequest = {
    import CreateTableRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.CreateTableRequest
      .builder()
      .databaseName(
        ResourceCreateAPIName.unwrap(databaseName): java.lang.String
      )
      .tableName(ResourceCreateAPIName.unwrap(tableName): java.lang.String)
      .optionallyWith(retentionProperties.map(value => value.buildAwsValue()))(
        _.retentionProperties
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        magneticStoreWriteProperties.map(value => value.buildAwsValue())
      )(_.magneticStoreWriteProperties)
      .build()
  }
  def asReadOnly: zio.aws.timestreamwrite.model.CreateTableRequest.ReadOnly =
    zio.aws.timestreamwrite.model.CreateTableRequest.wrap(buildAwsValue())
}
object CreateTableRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.CreateTableRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.CreateTableRequest =
      zio.aws.timestreamwrite.model.CreateTableRequest(
        databaseName,
        tableName,
        retentionProperties.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        magneticStoreWriteProperties.map(value => value.asEditable)
      )
    def databaseName: ResourceCreateAPIName
    def tableName: ResourceCreateAPIName
    def retentionProperties
        : Option[zio.aws.timestreamwrite.model.RetentionProperties.ReadOnly]
    def tags: Option[List[zio.aws.timestreamwrite.model.Tag.ReadOnly]]
    def magneticStoreWriteProperties: Option[
      zio.aws.timestreamwrite.model.MagneticStoreWriteProperties.ReadOnly
    ]
    def getDatabaseName: ZIO[Any, Nothing, ResourceCreateAPIName] =
      ZIO.succeed(databaseName)
    def getTableName: ZIO[Any, Nothing, ResourceCreateAPIName] =
      ZIO.succeed(tableName)
    def getRetentionProperties: ZIO[
      Any,
      AwsError,
      zio.aws.timestreamwrite.model.RetentionProperties.ReadOnly
    ] = AwsError.unwrapOptionField("retentionProperties", retentionProperties)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.timestreamwrite.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getMagneticStoreWriteProperties: ZIO[
      Any,
      AwsError,
      zio.aws.timestreamwrite.model.MagneticStoreWriteProperties.ReadOnly
    ] = AwsError.unwrapOptionField(
      "magneticStoreWriteProperties",
      magneticStoreWriteProperties
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.CreateTableRequest
  ) extends zio.aws.timestreamwrite.model.CreateTableRequest.ReadOnly {
    override val databaseName: ResourceCreateAPIName =
      zio.aws.timestreamwrite.model.primitives
        .ResourceCreateAPIName(impl.databaseName())
    override val tableName: ResourceCreateAPIName =
      zio.aws.timestreamwrite.model.primitives
        .ResourceCreateAPIName(impl.tableName())
    override val retentionProperties
        : Option[zio.aws.timestreamwrite.model.RetentionProperties.ReadOnly] =
      scala
        .Option(impl.retentionProperties())
        .map(value =>
          zio.aws.timestreamwrite.model.RetentionProperties.wrap(value)
        )
    override val tags
        : Option[List[zio.aws.timestreamwrite.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.timestreamwrite.model.Tag.wrap(item)
        }.toList
      )
    override val magneticStoreWriteProperties: Option[
      zio.aws.timestreamwrite.model.MagneticStoreWriteProperties.ReadOnly
    ] = scala
      .Option(impl.magneticStoreWriteProperties())
      .map(value =>
        zio.aws.timestreamwrite.model.MagneticStoreWriteProperties.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.CreateTableRequest
  ): zio.aws.timestreamwrite.model.CreateTableRequest.ReadOnly = new Wrapper(
    impl
  )
}
