package zio.aws.timestreamwrite.model
import zio.aws.timestreamwrite.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteDatabaseRequest(databaseName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.DeleteDatabaseRequest = {
    import DeleteDatabaseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.DeleteDatabaseRequest
      .builder()
      .databaseName(ResourceName.unwrap(databaseName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.timestreamwrite.model.DeleteDatabaseRequest.ReadOnly =
    zio.aws.timestreamwrite.model.DeleteDatabaseRequest.wrap(buildAwsValue())
}
object DeleteDatabaseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.DeleteDatabaseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.DeleteDatabaseRequest =
      zio.aws.timestreamwrite.model.DeleteDatabaseRequest(databaseName)
    def databaseName: ResourceName
    def getDatabaseName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(databaseName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.DeleteDatabaseRequest
  ) extends zio.aws.timestreamwrite.model.DeleteDatabaseRequest.ReadOnly {
    override val databaseName: ResourceName =
      zio.aws.timestreamwrite.model.primitives.ResourceName(impl.databaseName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.DeleteDatabaseRequest
  ): zio.aws.timestreamwrite.model.DeleteDatabaseRequest.ReadOnly = new Wrapper(
    impl
  )
}
