package zio.aws.timestreamwrite.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListTablesResponse(
    tables: Option[Iterable[zio.aws.timestreamwrite.model.Table]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.ListTablesResponse = {
    import ListTablesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.ListTablesResponse
      .builder()
      .optionallyWith(
        tables.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tables)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.timestreamwrite.model.ListTablesResponse.ReadOnly =
    zio.aws.timestreamwrite.model.ListTablesResponse.wrap(buildAwsValue())
}
object ListTablesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.ListTablesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.ListTablesResponse =
      zio.aws.timestreamwrite.model.ListTablesResponse(
        tables.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def tables: Option[List[zio.aws.timestreamwrite.model.Table.ReadOnly]]
    def nextToken: Option[String]
    def getTables: ZIO[Any, AwsError, List[
      zio.aws.timestreamwrite.model.Table.ReadOnly
    ]] = AwsError.unwrapOptionField("tables", tables)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.ListTablesResponse
  ) extends zio.aws.timestreamwrite.model.ListTablesResponse.ReadOnly {
    override val tables
        : Option[List[zio.aws.timestreamwrite.model.Table.ReadOnly]] = scala
      .Option(impl.tables())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.timestreamwrite.model.Table.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.ListTablesResponse
  ): zio.aws.timestreamwrite.model.ListTablesResponse.ReadOnly = new Wrapper(
    impl
  )
}
