package zio.aws.timestreamwrite.model
import zio.aws.timestreamwrite.model.primitives.{
  Date,
  StringValue2048,
  ResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Database(
    arn: Option[String] = None,
    databaseName: Option[ResourceName] = None,
    tableCount: Option[Long] = None,
    kmsKeyId: Option[StringValue2048] = None,
    creationTime: Option[Date] = None,
    lastUpdatedTime: Option[Date] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.Database = {
    import Database.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.Database
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(
        databaseName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.databaseName)
      .optionallyWith(tableCount.map(value => value: java.lang.Long))(
        _.tableCount
      )
      .optionallyWith(
        kmsKeyId.map(value => StringValue2048.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(creationTime.map(value => Date.unwrap(value): Instant))(
        _.creationTime
      )
      .optionallyWith(
        lastUpdatedTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .build()
  }
  def asReadOnly: zio.aws.timestreamwrite.model.Database.ReadOnly =
    zio.aws.timestreamwrite.model.Database.wrap(buildAwsValue())
}
object Database {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.Database
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.Database =
      zio.aws.timestreamwrite.model.Database(
        arn.map(value => value),
        databaseName.map(value => value),
        tableCount.map(value => value),
        kmsKeyId.map(value => value),
        creationTime.map(value => value),
        lastUpdatedTime.map(value => value)
      )
    def arn: Option[String]
    def databaseName: Option[ResourceName]
    def tableCount: Option[Long]
    def kmsKeyId: Option[StringValue2048]
    def creationTime: Option[Date]
    def lastUpdatedTime: Option[Date]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getDatabaseName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getTableCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("tableCount", tableCount)
    def getKmsKeyId: ZIO[Any, AwsError, StringValue2048] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getCreationTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastUpdatedTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.Database
  ) extends zio.aws.timestreamwrite.model.Database.ReadOnly {
    override val arn: Option[String] =
      scala.Option(impl.arn()).map(value => value: String)
    override val databaseName: Option[ResourceName] = scala
      .Option(impl.databaseName())
      .map(value =>
        zio.aws.timestreamwrite.model.primitives.ResourceName(value)
      )
    override val tableCount: Option[Long] =
      scala.Option(impl.tableCount()).map(value => value: Long)
    override val kmsKeyId: Option[StringValue2048] = scala
      .Option(impl.kmsKeyId())
      .map(value =>
        zio.aws.timestreamwrite.model.primitives.StringValue2048(value)
      )
    override val creationTime: Option[Date] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.timestreamwrite.model.primitives.Date(value))
    override val lastUpdatedTime: Option[Date] = scala
      .Option(impl.lastUpdatedTime())
      .map(value => zio.aws.timestreamwrite.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.Database
  ): zio.aws.timestreamwrite.model.Database.ReadOnly = new Wrapper(impl)
}
