package zio.aws.timestreamwrite.model
import scala.jdk.CollectionConverters.*
sealed trait DimensionValueType {
  def unwrap
      : software.amazon.awssdk.services.timestreamwrite.model.DimensionValueType
}
object DimensionValueType {
  def wrap(
      value: software.amazon.awssdk.services.timestreamwrite.model.DimensionValueType
  ): zio.aws.timestreamwrite.model.DimensionValueType = value match {
    case software.amazon.awssdk.services.timestreamwrite.model.DimensionValueType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.timestreamwrite.model.DimensionValueType.VARCHAR =>
      val r = VARCHAR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.timestreamwrite.model.DimensionValueType {
    override def unwrap
        : software.amazon.awssdk.services.timestreamwrite.model.DimensionValueType =
      software.amazon.awssdk.services.timestreamwrite.model.DimensionValueType.UNKNOWN_TO_SDK_VERSION
  }
  case object VARCHAR extends zio.aws.timestreamwrite.model.DimensionValueType {
    override def unwrap
        : software.amazon.awssdk.services.timestreamwrite.model.DimensionValueType =
      software.amazon.awssdk.services.timestreamwrite.model.DimensionValueType.VARCHAR
  }
}
