package zio.aws.timestreamwrite.model
import zio.aws.timestreamwrite.model.primitives.SchemaName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DimensionMapping(
    sourceColumn: Optional[SchemaName] = Optional.Absent,
    destinationColumn: Optional[SchemaName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.DimensionMapping = {
    import DimensionMapping.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.DimensionMapping
      .builder()
      .optionallyWith(
        sourceColumn.map(value => SchemaName.unwrap(value): java.lang.String)
      )(_.sourceColumn)
      .optionallyWith(
        destinationColumn.map(value =>
          SchemaName.unwrap(value): java.lang.String
        )
      )(_.destinationColumn)
      .build()
  }
  def asReadOnly: zio.aws.timestreamwrite.model.DimensionMapping.ReadOnly =
    zio.aws.timestreamwrite.model.DimensionMapping.wrap(buildAwsValue())
}
object DimensionMapping {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.DimensionMapping
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.DimensionMapping =
      zio.aws.timestreamwrite.model.DimensionMapping(
        sourceColumn.map(value => value),
        destinationColumn.map(value => value)
      )
    def sourceColumn: Optional[SchemaName]
    def destinationColumn: Optional[SchemaName]
    def getSourceColumn: ZIO[Any, AwsError, SchemaName] =
      AwsError.unwrapOptionField("sourceColumn", sourceColumn)
    def getDestinationColumn: ZIO[Any, AwsError, SchemaName] =
      AwsError.unwrapOptionField("destinationColumn", destinationColumn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.DimensionMapping
  ) extends zio.aws.timestreamwrite.model.DimensionMapping.ReadOnly {
    override val sourceColumn: Optional[SchemaName] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceColumn())
      .map(value => zio.aws.timestreamwrite.model.primitives.SchemaName(value))
    override val destinationColumn: Optional[SchemaName] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationColumn())
      .map(value => zio.aws.timestreamwrite.model.primitives.SchemaName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.DimensionMapping
  ): zio.aws.timestreamwrite.model.DimensionMapping.ReadOnly = new Wrapper(impl)
}
