package zio.aws.timestreamwrite.model
import scala.jdk.CollectionConverters._
sealed trait BatchLoadDataFormat {
  def unwrap: software.amazon.awssdk.services.timestreamwrite.model.BatchLoadDataFormat
}
object BatchLoadDataFormat {
  def wrap(
      value: software.amazon.awssdk.services.timestreamwrite.model.BatchLoadDataFormat
  ): zio.aws.timestreamwrite.model.BatchLoadDataFormat = value match {
    case software.amazon.awssdk.services.timestreamwrite.model.BatchLoadDataFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.timestreamwrite.model.BatchLoadDataFormat.CSV =>
      val r = CSV
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.timestreamwrite.model.BatchLoadDataFormat {
    override def unwrap
        : software.amazon.awssdk.services.timestreamwrite.model.BatchLoadDataFormat =
      software.amazon.awssdk.services.timestreamwrite.model.BatchLoadDataFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object CSV extends zio.aws.timestreamwrite.model.BatchLoadDataFormat {
    override def unwrap
        : software.amazon.awssdk.services.timestreamwrite.model.BatchLoadDataFormat =
      software.amazon.awssdk.services.timestreamwrite.model.BatchLoadDataFormat.CSV
  }
}
