package zio.aws.timestreamwrite.model
import zio.aws.timestreamwrite.model.primitives.{StringValue256, StringValue1}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CsvConfiguration(
    columnSeparator: Optional[StringValue1] = Optional.Absent,
    escapeChar: Optional[StringValue1] = Optional.Absent,
    quoteChar: Optional[StringValue1] = Optional.Absent,
    nullValue: Optional[StringValue256] = Optional.Absent,
    trimWhiteSpace: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.CsvConfiguration = {
    import CsvConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.CsvConfiguration
      .builder()
      .optionallyWith(
        columnSeparator.map(value =>
          StringValue1.unwrap(value): java.lang.String
        )
      )(_.columnSeparator)
      .optionallyWith(
        escapeChar.map(value => StringValue1.unwrap(value): java.lang.String)
      )(_.escapeChar)
      .optionallyWith(
        quoteChar.map(value => StringValue1.unwrap(value): java.lang.String)
      )(_.quoteChar)
      .optionallyWith(
        nullValue.map(value => StringValue256.unwrap(value): java.lang.String)
      )(_.nullValue)
      .optionallyWith(trimWhiteSpace.map(value => value: java.lang.Boolean))(
        _.trimWhiteSpace
      )
      .build()
  }
  def asReadOnly: zio.aws.timestreamwrite.model.CsvConfiguration.ReadOnly =
    zio.aws.timestreamwrite.model.CsvConfiguration.wrap(buildAwsValue())
}
object CsvConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.CsvConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.CsvConfiguration =
      zio.aws.timestreamwrite.model.CsvConfiguration(
        columnSeparator.map(value => value),
        escapeChar.map(value => value),
        quoteChar.map(value => value),
        nullValue.map(value => value),
        trimWhiteSpace.map(value => value)
      )
    def columnSeparator: Optional[StringValue1]
    def escapeChar: Optional[StringValue1]
    def quoteChar: Optional[StringValue1]
    def nullValue: Optional[StringValue256]
    def trimWhiteSpace: Optional[Boolean]
    def getColumnSeparator: ZIO[Any, AwsError, StringValue1] =
      AwsError.unwrapOptionField("columnSeparator", columnSeparator)
    def getEscapeChar: ZIO[Any, AwsError, StringValue1] =
      AwsError.unwrapOptionField("escapeChar", escapeChar)
    def getQuoteChar: ZIO[Any, AwsError, StringValue1] =
      AwsError.unwrapOptionField("quoteChar", quoteChar)
    def getNullValue: ZIO[Any, AwsError, StringValue256] =
      AwsError.unwrapOptionField("nullValue", nullValue)
    def getTrimWhiteSpace: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("trimWhiteSpace", trimWhiteSpace)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.CsvConfiguration
  ) extends zio.aws.timestreamwrite.model.CsvConfiguration.ReadOnly {
    override val columnSeparator: Optional[StringValue1] = zio.aws.core.internal
      .optionalFromNullable(impl.columnSeparator())
      .map(value =>
        zio.aws.timestreamwrite.model.primitives.StringValue1(value)
      )
    override val escapeChar: Optional[StringValue1] = zio.aws.core.internal
      .optionalFromNullable(impl.escapeChar())
      .map(value =>
        zio.aws.timestreamwrite.model.primitives.StringValue1(value)
      )
    override val quoteChar: Optional[StringValue1] = zio.aws.core.internal
      .optionalFromNullable(impl.quoteChar())
      .map(value =>
        zio.aws.timestreamwrite.model.primitives.StringValue1(value)
      )
    override val nullValue: Optional[StringValue256] = zio.aws.core.internal
      .optionalFromNullable(impl.nullValue())
      .map(value =>
        zio.aws.timestreamwrite.model.primitives.StringValue256(value)
      )
    override val trimWhiteSpace: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.trimWhiteSpace())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.CsvConfiguration
  ): zio.aws.timestreamwrite.model.CsvConfiguration.ReadOnly = new Wrapper(impl)
}
