package zio.aws.timestreamwrite.model
import zio.aws.timestreamwrite.model.primitives.BatchLoadTaskId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateBatchLoadTaskResponse(taskId: BatchLoadTaskId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.CreateBatchLoadTaskResponse = {
    import CreateBatchLoadTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.CreateBatchLoadTaskResponse
      .builder()
      .taskId(BatchLoadTaskId.unwrap(taskId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.timestreamwrite.model.CreateBatchLoadTaskResponse.ReadOnly =
    zio.aws.timestreamwrite.model.CreateBatchLoadTaskResponse
      .wrap(buildAwsValue())
}
object CreateBatchLoadTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.CreateBatchLoadTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.CreateBatchLoadTaskResponse =
      zio.aws.timestreamwrite.model.CreateBatchLoadTaskResponse(taskId)
    def taskId: BatchLoadTaskId
    def getTaskId: ZIO[Any, Nothing, BatchLoadTaskId] = ZIO.succeed(taskId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.CreateBatchLoadTaskResponse
  ) extends zio.aws.timestreamwrite.model.CreateBatchLoadTaskResponse.ReadOnly {
    override val taskId: BatchLoadTaskId =
      zio.aws.timestreamwrite.model.primitives.BatchLoadTaskId(impl.taskId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.CreateBatchLoadTaskResponse
  ): zio.aws.timestreamwrite.model.CreateBatchLoadTaskResponse.ReadOnly =
    new Wrapper(impl)
}
