package zio.aws.timestreamwrite.model
import zio.aws.timestreamwrite.model.primitives.StringValue256
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DataModel(
    timeColumn: Optional[StringValue256] = Optional.Absent,
    timeUnit: Optional[zio.aws.timestreamwrite.model.TimeUnit] =
      Optional.Absent,
    dimensionMappings: Iterable[zio.aws.timestreamwrite.model.DimensionMapping],
    multiMeasureMappings: Optional[
      zio.aws.timestreamwrite.model.MultiMeasureMappings
    ] = Optional.Absent,
    mixedMeasureMappings: Optional[
      Iterable[zio.aws.timestreamwrite.model.MixedMeasureMapping]
    ] = Optional.Absent,
    measureNameColumn: Optional[StringValue256] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.DataModel = {
    import DataModel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.DataModel
      .builder()
      .optionallyWith(
        timeColumn.map(value => StringValue256.unwrap(value): java.lang.String)
      )(_.timeColumn)
      .optionallyWith(timeUnit.map(value => value.unwrap))(_.timeUnit)
      .dimensionMappings(dimensionMappings.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(multiMeasureMappings.map(value => value.buildAwsValue()))(
        _.multiMeasureMappings
      )
      .optionallyWith(
        mixedMeasureMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.mixedMeasureMappings)
      .optionallyWith(
        measureNameColumn.map(value =>
          StringValue256.unwrap(value): java.lang.String
        )
      )(_.measureNameColumn)
      .build()
  }
  def asReadOnly: zio.aws.timestreamwrite.model.DataModel.ReadOnly =
    zio.aws.timestreamwrite.model.DataModel.wrap(buildAwsValue())
}
object DataModel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.DataModel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.DataModel =
      zio.aws.timestreamwrite.model.DataModel(
        timeColumn.map(value => value),
        timeUnit.map(value => value),
        dimensionMappings.map { item =>
          item.asEditable
        },
        multiMeasureMappings.map(value => value.asEditable),
        mixedMeasureMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        measureNameColumn.map(value => value)
      )
    def timeColumn: Optional[StringValue256]
    def timeUnit: Optional[zio.aws.timestreamwrite.model.TimeUnit]
    def dimensionMappings
        : List[zio.aws.timestreamwrite.model.DimensionMapping.ReadOnly]
    def multiMeasureMappings
        : Optional[zio.aws.timestreamwrite.model.MultiMeasureMappings.ReadOnly]
    def mixedMeasureMappings: Optional[
      List[zio.aws.timestreamwrite.model.MixedMeasureMapping.ReadOnly]
    ]
    def measureNameColumn: Optional[StringValue256]
    def getTimeColumn: ZIO[Any, AwsError, StringValue256] =
      AwsError.unwrapOptionField("timeColumn", timeColumn)
    def getTimeUnit
        : ZIO[Any, AwsError, zio.aws.timestreamwrite.model.TimeUnit] =
      AwsError.unwrapOptionField("timeUnit", timeUnit)
    def getDimensionMappings: ZIO[Any, Nothing, List[
      zio.aws.timestreamwrite.model.DimensionMapping.ReadOnly
    ]] = ZIO.succeed(dimensionMappings)
    def getMultiMeasureMappings: ZIO[
      Any,
      AwsError,
      zio.aws.timestreamwrite.model.MultiMeasureMappings.ReadOnly
    ] = AwsError.unwrapOptionField("multiMeasureMappings", multiMeasureMappings)
    def getMixedMeasureMappings: ZIO[Any, AwsError, List[
      zio.aws.timestreamwrite.model.MixedMeasureMapping.ReadOnly
    ]] =
      AwsError.unwrapOptionField("mixedMeasureMappings", mixedMeasureMappings)
    def getMeasureNameColumn: ZIO[Any, AwsError, StringValue256] =
      AwsError.unwrapOptionField("measureNameColumn", measureNameColumn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.DataModel
  ) extends zio.aws.timestreamwrite.model.DataModel.ReadOnly {
    override val timeColumn: Optional[StringValue256] = zio.aws.core.internal
      .optionalFromNullable(impl.timeColumn())
      .map(value =>
        zio.aws.timestreamwrite.model.primitives.StringValue256(value)
      )
    override val timeUnit: Optional[zio.aws.timestreamwrite.model.TimeUnit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeUnit())
        .map(value => zio.aws.timestreamwrite.model.TimeUnit.wrap(value))
    override val dimensionMappings
        : List[zio.aws.timestreamwrite.model.DimensionMapping.ReadOnly] = impl
      .dimensionMappings()
      .asScala
      .map { item =>
        zio.aws.timestreamwrite.model.DimensionMapping.wrap(item)
      }
      .toList
    override val multiMeasureMappings: Optional[
      zio.aws.timestreamwrite.model.MultiMeasureMappings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.multiMeasureMappings())
      .map(value =>
        zio.aws.timestreamwrite.model.MultiMeasureMappings.wrap(value)
      )
    override val mixedMeasureMappings: Optional[
      List[zio.aws.timestreamwrite.model.MixedMeasureMapping.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.mixedMeasureMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.timestreamwrite.model.MixedMeasureMapping.wrap(item)
        }.toList
      )
    override val measureNameColumn: Optional[StringValue256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.measureNameColumn())
        .map(value =>
          zio.aws.timestreamwrite.model.primitives.StringValue256(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.DataModel
  ): zio.aws.timestreamwrite.model.DataModel.ReadOnly = new Wrapper(impl)
}
