package zio.aws.timestreamwrite.model
import zio.aws.timestreamwrite.model.primitives.{
  StringValue2048,
  S3ObjectKeyPrefix,
  S3BucketName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReportS3Configuration(
    bucketName: S3BucketName,
    objectKeyPrefix: Optional[S3ObjectKeyPrefix] = Optional.Absent,
    encryptionOption: Optional[
      zio.aws.timestreamwrite.model.S3EncryptionOption
    ] = Optional.Absent,
    kmsKeyId: Optional[StringValue2048] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.ReportS3Configuration = {
    import ReportS3Configuration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.ReportS3Configuration
      .builder()
      .bucketName(S3BucketName.unwrap(bucketName): java.lang.String)
      .optionallyWith(
        objectKeyPrefix.map(value =>
          S3ObjectKeyPrefix.unwrap(value): java.lang.String
        )
      )(_.objectKeyPrefix)
      .optionallyWith(encryptionOption.map(value => value.unwrap))(
        _.encryptionOption
      )
      .optionallyWith(
        kmsKeyId.map(value => StringValue2048.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .build()
  }
  def asReadOnly: zio.aws.timestreamwrite.model.ReportS3Configuration.ReadOnly =
    zio.aws.timestreamwrite.model.ReportS3Configuration.wrap(buildAwsValue())
}
object ReportS3Configuration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.ReportS3Configuration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.ReportS3Configuration =
      zio.aws.timestreamwrite.model.ReportS3Configuration(
        bucketName,
        objectKeyPrefix.map(value => value),
        encryptionOption.map(value => value),
        kmsKeyId.map(value => value)
      )
    def bucketName: S3BucketName
    def objectKeyPrefix: Optional[S3ObjectKeyPrefix]
    def encryptionOption
        : Optional[zio.aws.timestreamwrite.model.S3EncryptionOption]
    def kmsKeyId: Optional[StringValue2048]
    def getBucketName: ZIO[Any, Nothing, S3BucketName] = ZIO.succeed(bucketName)
    def getObjectKeyPrefix: ZIO[Any, AwsError, S3ObjectKeyPrefix] =
      AwsError.unwrapOptionField("objectKeyPrefix", objectKeyPrefix)
    def getEncryptionOption
        : ZIO[Any, AwsError, zio.aws.timestreamwrite.model.S3EncryptionOption] =
      AwsError.unwrapOptionField("encryptionOption", encryptionOption)
    def getKmsKeyId: ZIO[Any, AwsError, StringValue2048] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.ReportS3Configuration
  ) extends zio.aws.timestreamwrite.model.ReportS3Configuration.ReadOnly {
    override val bucketName: S3BucketName =
      zio.aws.timestreamwrite.model.primitives.S3BucketName(impl.bucketName())
    override val objectKeyPrefix: Optional[S3ObjectKeyPrefix] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectKeyPrefix())
        .map(value =>
          zio.aws.timestreamwrite.model.primitives.S3ObjectKeyPrefix(value)
        )
    override val encryptionOption
        : Optional[zio.aws.timestreamwrite.model.S3EncryptionOption] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionOption())
        .map(value =>
          zio.aws.timestreamwrite.model.S3EncryptionOption.wrap(value)
        )
    override val kmsKeyId: Optional[StringValue2048] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value =>
        zio.aws.timestreamwrite.model.primitives.StringValue2048(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.ReportS3Configuration
  ): zio.aws.timestreamwrite.model.ReportS3Configuration.ReadOnly = new Wrapper(
    impl
  )
}
