package zio.aws.timestreamwrite.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.timestreamwrite.model.primitives.{
  RecordVersion,
  Date,
  StringValue2048,
  BatchLoadTaskId,
  ResourceName
}
import scala.jdk.CollectionConverters._
final case class BatchLoadTaskDescription(
    taskId: Optional[BatchLoadTaskId] = Optional.Absent,
    errorMessage: Optional[StringValue2048] = Optional.Absent,
    dataSourceConfiguration: Optional[
      zio.aws.timestreamwrite.model.DataSourceConfiguration
    ] = Optional.Absent,
    progressReport: Optional[
      zio.aws.timestreamwrite.model.BatchLoadProgressReport
    ] = Optional.Absent,
    reportConfiguration: Optional[
      zio.aws.timestreamwrite.model.ReportConfiguration
    ] = Optional.Absent,
    dataModelConfiguration: Optional[
      zio.aws.timestreamwrite.model.DataModelConfiguration
    ] = Optional.Absent,
    targetDatabaseName: Optional[ResourceName] = Optional.Absent,
    targetTableName: Optional[ResourceName] = Optional.Absent,
    taskStatus: Optional[zio.aws.timestreamwrite.model.BatchLoadStatus] =
      Optional.Absent,
    recordVersion: Optional[RecordVersion] = Optional.Absent,
    creationTime: Optional[Date] = Optional.Absent,
    lastUpdatedTime: Optional[Date] = Optional.Absent,
    resumableUntil: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.BatchLoadTaskDescription = {
    import BatchLoadTaskDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.BatchLoadTaskDescription
      .builder()
      .optionallyWith(
        taskId.map(value => BatchLoadTaskId.unwrap(value): java.lang.String)
      )(_.taskId)
      .optionallyWith(
        errorMessage.map(value =>
          StringValue2048.unwrap(value): java.lang.String
        )
      )(_.errorMessage)
      .optionallyWith(
        dataSourceConfiguration.map(value => value.buildAwsValue())
      )(_.dataSourceConfiguration)
      .optionallyWith(progressReport.map(value => value.buildAwsValue()))(
        _.progressReport
      )
      .optionallyWith(reportConfiguration.map(value => value.buildAwsValue()))(
        _.reportConfiguration
      )
      .optionallyWith(
        dataModelConfiguration.map(value => value.buildAwsValue())
      )(_.dataModelConfiguration)
      .optionallyWith(
        targetDatabaseName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.targetDatabaseName)
      .optionallyWith(
        targetTableName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.targetTableName)
      .optionallyWith(taskStatus.map(value => value.unwrap))(_.taskStatus)
      .optionallyWith(
        recordVersion.map(value => RecordVersion.unwrap(value): java.lang.Long)
      )(_.recordVersion)
      .optionallyWith(creationTime.map(value => Date.unwrap(value): Instant))(
        _.creationTime
      )
      .optionallyWith(
        lastUpdatedTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(resumableUntil.map(value => Date.unwrap(value): Instant))(
        _.resumableUntil
      )
      .build()
  }
  def asReadOnly
      : zio.aws.timestreamwrite.model.BatchLoadTaskDescription.ReadOnly =
    zio.aws.timestreamwrite.model.BatchLoadTaskDescription.wrap(buildAwsValue())
}
object BatchLoadTaskDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.BatchLoadTaskDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.BatchLoadTaskDescription =
      zio.aws.timestreamwrite.model.BatchLoadTaskDescription(
        taskId.map(value => value),
        errorMessage.map(value => value),
        dataSourceConfiguration.map(value => value.asEditable),
        progressReport.map(value => value.asEditable),
        reportConfiguration.map(value => value.asEditable),
        dataModelConfiguration.map(value => value.asEditable),
        targetDatabaseName.map(value => value),
        targetTableName.map(value => value),
        taskStatus.map(value => value),
        recordVersion.map(value => value),
        creationTime.map(value => value),
        lastUpdatedTime.map(value => value),
        resumableUntil.map(value => value)
      )
    def taskId: Optional[BatchLoadTaskId]
    def errorMessage: Optional[StringValue2048]
    def dataSourceConfiguration: Optional[
      zio.aws.timestreamwrite.model.DataSourceConfiguration.ReadOnly
    ]
    def progressReport: Optional[
      zio.aws.timestreamwrite.model.BatchLoadProgressReport.ReadOnly
    ]
    def reportConfiguration
        : Optional[zio.aws.timestreamwrite.model.ReportConfiguration.ReadOnly]
    def dataModelConfiguration: Optional[
      zio.aws.timestreamwrite.model.DataModelConfiguration.ReadOnly
    ]
    def targetDatabaseName: Optional[ResourceName]
    def targetTableName: Optional[ResourceName]
    def taskStatus: Optional[zio.aws.timestreamwrite.model.BatchLoadStatus]
    def recordVersion: Optional[RecordVersion]
    def creationTime: Optional[Date]
    def lastUpdatedTime: Optional[Date]
    def resumableUntil: Optional[Date]
    def getTaskId: ZIO[Any, AwsError, BatchLoadTaskId] =
      AwsError.unwrapOptionField("taskId", taskId)
    def getErrorMessage: ZIO[Any, AwsError, StringValue2048] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getDataSourceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.timestreamwrite.model.DataSourceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dataSourceConfiguration",
      dataSourceConfiguration
    )
    def getProgressReport: ZIO[
      Any,
      AwsError,
      zio.aws.timestreamwrite.model.BatchLoadProgressReport.ReadOnly
    ] = AwsError.unwrapOptionField("progressReport", progressReport)
    def getReportConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.timestreamwrite.model.ReportConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("reportConfiguration", reportConfiguration)
    def getDataModelConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.timestreamwrite.model.DataModelConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dataModelConfiguration",
      dataModelConfiguration
    )
    def getTargetDatabaseName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("targetDatabaseName", targetDatabaseName)
    def getTargetTableName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("targetTableName", targetTableName)
    def getTaskStatus
        : ZIO[Any, AwsError, zio.aws.timestreamwrite.model.BatchLoadStatus] =
      AwsError.unwrapOptionField("taskStatus", taskStatus)
    def getRecordVersion: ZIO[Any, AwsError, RecordVersion] =
      AwsError.unwrapOptionField("recordVersion", recordVersion)
    def getCreationTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastUpdatedTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getResumableUntil: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("resumableUntil", resumableUntil)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.BatchLoadTaskDescription
  ) extends zio.aws.timestreamwrite.model.BatchLoadTaskDescription.ReadOnly {
    override val taskId: Optional[BatchLoadTaskId] = zio.aws.core.internal
      .optionalFromNullable(impl.taskId())
      .map(value =>
        zio.aws.timestreamwrite.model.primitives.BatchLoadTaskId(value)
      )
    override val errorMessage: Optional[StringValue2048] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value =>
        zio.aws.timestreamwrite.model.primitives.StringValue2048(value)
      )
    override val dataSourceConfiguration: Optional[
      zio.aws.timestreamwrite.model.DataSourceConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dataSourceConfiguration())
      .map(value =>
        zio.aws.timestreamwrite.model.DataSourceConfiguration.wrap(value)
      )
    override val progressReport: Optional[
      zio.aws.timestreamwrite.model.BatchLoadProgressReport.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.progressReport())
      .map(value =>
        zio.aws.timestreamwrite.model.BatchLoadProgressReport.wrap(value)
      )
    override val reportConfiguration
        : Optional[zio.aws.timestreamwrite.model.ReportConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reportConfiguration())
        .map(value =>
          zio.aws.timestreamwrite.model.ReportConfiguration.wrap(value)
        )
    override val dataModelConfiguration: Optional[
      zio.aws.timestreamwrite.model.DataModelConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dataModelConfiguration())
      .map(value =>
        zio.aws.timestreamwrite.model.DataModelConfiguration.wrap(value)
      )
    override val targetDatabaseName: Optional[ResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetDatabaseName())
        .map(value =>
          zio.aws.timestreamwrite.model.primitives.ResourceName(value)
        )
    override val targetTableName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.targetTableName())
      .map(value =>
        zio.aws.timestreamwrite.model.primitives.ResourceName(value)
      )
    override val taskStatus
        : Optional[zio.aws.timestreamwrite.model.BatchLoadStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskStatus())
        .map(value => zio.aws.timestreamwrite.model.BatchLoadStatus.wrap(value))
    override val recordVersion: Optional[RecordVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.recordVersion())
      .map(value =>
        zio.aws.timestreamwrite.model.primitives.RecordVersion(value)
      )
    override val creationTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.timestreamwrite.model.primitives.Date(value))
    override val lastUpdatedTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedTime())
      .map(value => zio.aws.timestreamwrite.model.primitives.Date(value))
    override val resumableUntil: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.resumableUntil())
      .map(value => zio.aws.timestreamwrite.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.BatchLoadTaskDescription
  ): zio.aws.timestreamwrite.model.BatchLoadTaskDescription.ReadOnly =
    new Wrapper(impl)
}
