package zio.aws.timestreamwrite.model
import zio.aws.timestreamwrite.model.primitives.{SchemaValue, SchemaName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Dimension(
    name: SchemaName,
    value: SchemaValue,
    dimensionValueType: Optional[
      zio.aws.timestreamwrite.model.DimensionValueType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.Dimension = {
    import Dimension.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.Dimension
      .builder()
      .name(SchemaName.unwrap(name): java.lang.String)
      .value(SchemaValue.unwrap(value): java.lang.String)
      .optionallyWith(dimensionValueType.map(value => value.unwrap))(
        _.dimensionValueType
      )
      .build()
  }
  def asReadOnly: zio.aws.timestreamwrite.model.Dimension.ReadOnly =
    zio.aws.timestreamwrite.model.Dimension.wrap(buildAwsValue())
}
object Dimension {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.Dimension
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.Dimension =
      zio.aws.timestreamwrite.model
        .Dimension(name, value, dimensionValueType.map(value => value))
    def name: SchemaName
    def value: SchemaValue
    def dimensionValueType
        : Optional[zio.aws.timestreamwrite.model.DimensionValueType]
    def getName: ZIO[Any, Nothing, SchemaName] = ZIO.succeed(name)
    def getValue: ZIO[Any, Nothing, SchemaValue] = ZIO.succeed(value)
    def getDimensionValueType
        : ZIO[Any, AwsError, zio.aws.timestreamwrite.model.DimensionValueType] =
      AwsError.unwrapOptionField("dimensionValueType", dimensionValueType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.Dimension
  ) extends zio.aws.timestreamwrite.model.Dimension.ReadOnly {
    override val name: SchemaName =
      zio.aws.timestreamwrite.model.primitives.SchemaName(impl.name())
    override val value: SchemaValue =
      zio.aws.timestreamwrite.model.primitives.SchemaValue(impl.value())
    override val dimensionValueType
        : Optional[zio.aws.timestreamwrite.model.DimensionValueType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dimensionValueType())
        .map(value =>
          zio.aws.timestreamwrite.model.DimensionValueType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.Dimension
  ): zio.aws.timestreamwrite.model.Dimension.ReadOnly = new Wrapper(impl)
}
