package zio.aws.timestreamwrite.model
import scala.jdk.CollectionConverters._
sealed trait BatchLoadStatus {
  def unwrap
      : software.amazon.awssdk.services.timestreamwrite.model.BatchLoadStatus
}
object BatchLoadStatus {
  def wrap(
      value: software.amazon.awssdk.services.timestreamwrite.model.BatchLoadStatus
  ): zio.aws.timestreamwrite.model.BatchLoadStatus = value match {
    case software.amazon.awssdk.services.timestreamwrite.model.BatchLoadStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.timestreamwrite.model.BatchLoadStatus.CREATED =>
      val r = CREATED
      r
    case software.amazon.awssdk.services.timestreamwrite.model.BatchLoadStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.timestreamwrite.model.BatchLoadStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.timestreamwrite.model.BatchLoadStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.timestreamwrite.model.BatchLoadStatus.PROGRESS_STOPPED =>
      val r = PROGRESS_STOPPED
      r
    case software.amazon.awssdk.services.timestreamwrite.model.BatchLoadStatus.PENDING_RESUME =>
      val r = PENDING_RESUME
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.timestreamwrite.model.BatchLoadStatus {
    override def unwrap
        : software.amazon.awssdk.services.timestreamwrite.model.BatchLoadStatus =
      software.amazon.awssdk.services.timestreamwrite.model.BatchLoadStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATED extends zio.aws.timestreamwrite.model.BatchLoadStatus {
    override def unwrap
        : software.amazon.awssdk.services.timestreamwrite.model.BatchLoadStatus =
      software.amazon.awssdk.services.timestreamwrite.model.BatchLoadStatus.CREATED
  }
  case object IN_PROGRESS
      extends zio.aws.timestreamwrite.model.BatchLoadStatus {
    override def unwrap
        : software.amazon.awssdk.services.timestreamwrite.model.BatchLoadStatus =
      software.amazon.awssdk.services.timestreamwrite.model.BatchLoadStatus.IN_PROGRESS
  }
  case object FAILED extends zio.aws.timestreamwrite.model.BatchLoadStatus {
    override def unwrap
        : software.amazon.awssdk.services.timestreamwrite.model.BatchLoadStatus =
      software.amazon.awssdk.services.timestreamwrite.model.BatchLoadStatus.FAILED
  }
  case object SUCCEEDED extends zio.aws.timestreamwrite.model.BatchLoadStatus {
    override def unwrap
        : software.amazon.awssdk.services.timestreamwrite.model.BatchLoadStatus =
      software.amazon.awssdk.services.timestreamwrite.model.BatchLoadStatus.SUCCEEDED
  }
  case object PROGRESS_STOPPED
      extends zio.aws.timestreamwrite.model.BatchLoadStatus {
    override def unwrap
        : software.amazon.awssdk.services.timestreamwrite.model.BatchLoadStatus =
      software.amazon.awssdk.services.timestreamwrite.model.BatchLoadStatus.PROGRESS_STOPPED
  }
  case object PENDING_RESUME
      extends zio.aws.timestreamwrite.model.BatchLoadStatus {
    override def unwrap
        : software.amazon.awssdk.services.timestreamwrite.model.BatchLoadStatus =
      software.amazon.awssdk.services.timestreamwrite.model.BatchLoadStatus.PENDING_RESUME
  }
}
