package zio.aws.timestreamwrite.model
import zio.aws.timestreamwrite.model.primitives.{StringValue2048, ResourceName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateDatabaseRequest(
    databaseName: ResourceName,
    kmsKeyId: StringValue2048
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.UpdateDatabaseRequest = {
    import UpdateDatabaseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.UpdateDatabaseRequest
      .builder()
      .databaseName(ResourceName.unwrap(databaseName): java.lang.String)
      .kmsKeyId(StringValue2048.unwrap(kmsKeyId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.timestreamwrite.model.UpdateDatabaseRequest.ReadOnly =
    zio.aws.timestreamwrite.model.UpdateDatabaseRequest.wrap(buildAwsValue())
}
object UpdateDatabaseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.UpdateDatabaseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.UpdateDatabaseRequest =
      zio.aws.timestreamwrite.model
        .UpdateDatabaseRequest(databaseName, kmsKeyId)
    def databaseName: ResourceName
    def kmsKeyId: StringValue2048
    def getDatabaseName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(databaseName)
    def getKmsKeyId: ZIO[Any, Nothing, StringValue2048] = ZIO.succeed(kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.UpdateDatabaseRequest
  ) extends zio.aws.timestreamwrite.model.UpdateDatabaseRequest.ReadOnly {
    override val databaseName: ResourceName =
      zio.aws.timestreamwrite.model.primitives.ResourceName(impl.databaseName())
    override val kmsKeyId: StringValue2048 =
      zio.aws.timestreamwrite.model.primitives.StringValue2048(impl.kmsKeyId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.UpdateDatabaseRequest
  ): zio.aws.timestreamwrite.model.UpdateDatabaseRequest.ReadOnly = new Wrapper(
    impl
  )
}
