package zio.aws.timestreamwrite.model
import zio.aws.timestreamwrite.model.primitives.AmazonResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(resourceARN: AmazonResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.ListTagsForResourceRequest
      .builder()
      .resourceARN(AmazonResourceName.unwrap(resourceARN): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.timestreamwrite.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.timestreamwrite.model.ListTagsForResourceRequest
      .wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.ListTagsForResourceRequest =
      zio.aws.timestreamwrite.model.ListTagsForResourceRequest(resourceARN)
    def resourceARN: AmazonResourceName
    def getResourceARN: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.ListTagsForResourceRequest
  ) extends zio.aws.timestreamwrite.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceARN: AmazonResourceName =
      zio.aws.timestreamwrite.model.primitives
        .AmazonResourceName(impl.resourceARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.ListTagsForResourceRequest
  ): zio.aws.timestreamwrite.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
