package zio.aws.timestreamwrite.model
import zio.aws.timestreamwrite.model.primitives.{TagKey, AmazonResourceName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(
    resourceARN: AmazonResourceName,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.UntagResourceRequest
      .builder()
      .resourceARN(AmazonResourceName.unwrap(resourceARN): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.timestreamwrite.model.UntagResourceRequest.ReadOnly =
    zio.aws.timestreamwrite.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.UntagResourceRequest =
      zio.aws.timestreamwrite.model.UntagResourceRequest(resourceARN, tagKeys)
    def resourceARN: AmazonResourceName
    def tagKeys: List[TagKey]
    def getResourceARN: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceARN)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.UntagResourceRequest
  ) extends zio.aws.timestreamwrite.model.UntagResourceRequest.ReadOnly {
    override val resourceARN: AmazonResourceName =
      zio.aws.timestreamwrite.model.primitives
        .AmazonResourceName(impl.resourceARN())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.timestreamwrite.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.UntagResourceRequest
  ): zio.aws.timestreamwrite.model.UntagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
