package zio.aws.timestreamwrite
import zio.aws.timestreamwrite.model.CreateTableResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.timestreamwrite.model.{
  CreateDatabaseRequest,
  DescribeEndpointsRequest,
  DescribeTableRequest,
  DescribeDatabaseRequest,
  ListTagsForResourceRequest,
  UpdateTableRequest,
  ListDatabasesRequest,
  CreateTableRequest,
  UntagResourceRequest,
  DeleteTableRequest,
  UpdateDatabaseRequest,
  WriteRecordsRequest,
  ListTablesRequest,
  DeleteDatabaseRequest,
  TagResourceRequest
}
import zio.stream.ZStream
import software.amazon.awssdk.services.timestreamwrite.TimestreamWriteAsyncClient
object TimestreamWriteMock extends Mock[TimestreamWrite] {
  object ListDatabases
      extends Stream[
        ListDatabasesRequest,
        AwsError,
        zio.aws.timestreamwrite.model.Database.ReadOnly
      ]
  object ListDatabasesPaginated
      extends Effect[
        ListDatabasesRequest,
        AwsError,
        zio.aws.timestreamwrite.model.ListDatabasesResponse.ReadOnly
      ]
  object CreateTable extends Effect[CreateTableRequest, AwsError, ReadOnly]
  object DeleteTable extends Effect[DeleteTableRequest, AwsError, Unit]
  object CreateDatabase
      extends Effect[
        CreateDatabaseRequest,
        AwsError,
        zio.aws.timestreamwrite.model.CreateDatabaseResponse.ReadOnly
      ]
  object DescribeDatabase
      extends Effect[
        DescribeDatabaseRequest,
        AwsError,
        zio.aws.timestreamwrite.model.DescribeDatabaseResponse.ReadOnly
      ]
  object ListTables
      extends Stream[
        ListTablesRequest,
        AwsError,
        zio.aws.timestreamwrite.model.Table.ReadOnly
      ]
  object ListTablesPaginated
      extends Effect[
        ListTablesRequest,
        AwsError,
        zio.aws.timestreamwrite.model.ListTablesResponse.ReadOnly
      ]
  object DescribeTable
      extends Effect[
        DescribeTableRequest,
        AwsError,
        zio.aws.timestreamwrite.model.DescribeTableResponse.ReadOnly
      ]
  object UpdateTable
      extends Effect[
        UpdateTableRequest,
        AwsError,
        zio.aws.timestreamwrite.model.UpdateTableResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.timestreamwrite.model.UntagResourceResponse.ReadOnly
      ]
  object DeleteDatabase extends Effect[DeleteDatabaseRequest, AwsError, Unit]
  object DescribeEndpoints
      extends Effect[
        DescribeEndpointsRequest,
        AwsError,
        zio.aws.timestreamwrite.model.DescribeEndpointsResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.timestreamwrite.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.timestreamwrite.model.TagResourceResponse.ReadOnly
      ]
  object UpdateDatabase
      extends Effect[
        UpdateDatabaseRequest,
        AwsError,
        zio.aws.timestreamwrite.model.UpdateDatabaseResponse.ReadOnly
      ]
  object WriteRecords
      extends Effect[
        WriteRecordsRequest,
        AwsError,
        zio.aws.timestreamwrite.model.WriteRecordsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, TimestreamWrite] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, TimestreamWrite] { rts =>
        zio.ZIO.succeed {
          new TimestreamWrite {
            val api: TimestreamWriteAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): TimestreamWrite = this
            def listDatabases(request: ListDatabasesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.timestreamwrite.model.Database.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDatabases, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDatabasesPaginated(request: ListDatabasesRequest): IO[
              AwsError,
              zio.aws.timestreamwrite.model.ListDatabasesResponse.ReadOnly
            ] = proxy(ListDatabasesPaginated, request)
            def createTable(
                request: CreateTableRequest
            ): IO[AwsError, ReadOnly] = proxy(CreateTable, request)
            def deleteTable(request: DeleteTableRequest): IO[AwsError, Unit] =
              proxy(DeleteTable, request)
            def createDatabase(request: CreateDatabaseRequest): IO[
              AwsError,
              zio.aws.timestreamwrite.model.CreateDatabaseResponse.ReadOnly
            ] = proxy(CreateDatabase, request)
            def describeDatabase(request: DescribeDatabaseRequest): IO[
              AwsError,
              zio.aws.timestreamwrite.model.DescribeDatabaseResponse.ReadOnly
            ] = proxy(DescribeDatabase, request)
            def listTables(request: ListTablesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.timestreamwrite.model.Table.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListTables, request)
                }
                .getOrThrowFiberFailure()
            }
            def listTablesPaginated(request: ListTablesRequest): IO[
              AwsError,
              zio.aws.timestreamwrite.model.ListTablesResponse.ReadOnly
            ] = proxy(ListTablesPaginated, request)
            def describeTable(request: DescribeTableRequest): IO[
              AwsError,
              zio.aws.timestreamwrite.model.DescribeTableResponse.ReadOnly
            ] = proxy(DescribeTable, request)
            def updateTable(request: UpdateTableRequest): IO[
              AwsError,
              zio.aws.timestreamwrite.model.UpdateTableResponse.ReadOnly
            ] = proxy(UpdateTable, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.timestreamwrite.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def deleteDatabase(
                request: DeleteDatabaseRequest
            ): IO[AwsError, Unit] = proxy(DeleteDatabase, request)
            def describeEndpoints(request: DescribeEndpointsRequest): IO[
              AwsError,
              zio.aws.timestreamwrite.model.DescribeEndpointsResponse.ReadOnly
            ] = proxy(DescribeEndpoints, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.timestreamwrite.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.timestreamwrite.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def updateDatabase(request: UpdateDatabaseRequest): IO[
              AwsError,
              zio.aws.timestreamwrite.model.UpdateDatabaseResponse.ReadOnly
            ] = proxy(UpdateDatabase, request)
            def writeRecords(request: WriteRecordsRequest): IO[
              AwsError,
              zio.aws.timestreamwrite.model.WriteRecordsResponse.ReadOnly
            ] = proxy(WriteRecords, request)
          }
        }
      }
    }
  }
}
