package zio.aws.timestreamwrite.model
import zio.aws.timestreamwrite.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteTableRequest(
    databaseName: ResourceName,
    tableName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.DeleteTableRequest = {
    import DeleteTableRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.DeleteTableRequest
      .builder()
      .databaseName(ResourceName.unwrap(databaseName): java.lang.String)
      .tableName(ResourceName.unwrap(tableName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.timestreamwrite.model.DeleteTableRequest.ReadOnly =
    zio.aws.timestreamwrite.model.DeleteTableRequest.wrap(buildAwsValue())
}
object DeleteTableRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.DeleteTableRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.DeleteTableRequest =
      zio.aws.timestreamwrite.model.DeleteTableRequest(databaseName, tableName)
    def databaseName: ResourceName
    def tableName: ResourceName
    def getDatabaseName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(databaseName)
    def getTableName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(tableName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.DeleteTableRequest
  ) extends zio.aws.timestreamwrite.model.DeleteTableRequest.ReadOnly {
    override val databaseName: ResourceName =
      zio.aws.timestreamwrite.model.primitives.ResourceName(impl.databaseName())
    override val tableName: ResourceName =
      zio.aws.timestreamwrite.model.primitives.ResourceName(impl.tableName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.DeleteTableRequest
  ): zio.aws.timestreamwrite.model.DeleteTableRequest.ReadOnly = new Wrapper(
    impl
  )
}
