package zio.aws.timestreamwrite.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.timestreamwrite.model.primitives.{Date, ResourceName}
import scala.jdk.CollectionConverters._
final case class Table(
    arn: Optional[String] = Optional.Absent,
    tableName: Optional[ResourceName] = Optional.Absent,
    databaseName: Optional[ResourceName] = Optional.Absent,
    tableStatus: Optional[zio.aws.timestreamwrite.model.TableStatus] =
      Optional.Absent,
    retentionProperties: Optional[
      zio.aws.timestreamwrite.model.RetentionProperties
    ] = Optional.Absent,
    creationTime: Optional[Date] = Optional.Absent,
    lastUpdatedTime: Optional[Date] = Optional.Absent,
    magneticStoreWriteProperties: Optional[
      zio.aws.timestreamwrite.model.MagneticStoreWriteProperties
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.Table = {
    import Table.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.Table
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(
        tableName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.tableName)
      .optionallyWith(
        databaseName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.databaseName)
      .optionallyWith(tableStatus.map(value => value.unwrap))(_.tableStatus)
      .optionallyWith(retentionProperties.map(value => value.buildAwsValue()))(
        _.retentionProperties
      )
      .optionallyWith(creationTime.map(value => Date.unwrap(value): Instant))(
        _.creationTime
      )
      .optionallyWith(
        lastUpdatedTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(
        magneticStoreWriteProperties.map(value => value.buildAwsValue())
      )(_.magneticStoreWriteProperties)
      .build()
  }
  def asReadOnly: zio.aws.timestreamwrite.model.Table.ReadOnly =
    zio.aws.timestreamwrite.model.Table.wrap(buildAwsValue())
}
object Table {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.Table
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.Table =
      zio.aws.timestreamwrite.model.Table(
        arn.map(value => value),
        tableName.map(value => value),
        databaseName.map(value => value),
        tableStatus.map(value => value),
        retentionProperties.map(value => value.asEditable),
        creationTime.map(value => value),
        lastUpdatedTime.map(value => value),
        magneticStoreWriteProperties.map(value => value.asEditable)
      )
    def arn: Optional[String]
    def tableName: Optional[ResourceName]
    def databaseName: Optional[ResourceName]
    def tableStatus: Optional[zio.aws.timestreamwrite.model.TableStatus]
    def retentionProperties
        : Optional[zio.aws.timestreamwrite.model.RetentionProperties.ReadOnly]
    def creationTime: Optional[Date]
    def lastUpdatedTime: Optional[Date]
    def magneticStoreWriteProperties: Optional[
      zio.aws.timestreamwrite.model.MagneticStoreWriteProperties.ReadOnly
    ]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getTableName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("tableName", tableName)
    def getDatabaseName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getTableStatus
        : ZIO[Any, AwsError, zio.aws.timestreamwrite.model.TableStatus] =
      AwsError.unwrapOptionField("tableStatus", tableStatus)
    def getRetentionProperties: ZIO[
      Any,
      AwsError,
      zio.aws.timestreamwrite.model.RetentionProperties.ReadOnly
    ] = AwsError.unwrapOptionField("retentionProperties", retentionProperties)
    def getCreationTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastUpdatedTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getMagneticStoreWriteProperties: ZIO[
      Any,
      AwsError,
      zio.aws.timestreamwrite.model.MagneticStoreWriteProperties.ReadOnly
    ] = AwsError.unwrapOptionField(
      "magneticStoreWriteProperties",
      magneticStoreWriteProperties
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.Table
  ) extends zio.aws.timestreamwrite.model.Table.ReadOnly {
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val tableName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.tableName())
      .map(value =>
        zio.aws.timestreamwrite.model.primitives.ResourceName(value)
      )
    override val databaseName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseName())
      .map(value =>
        zio.aws.timestreamwrite.model.primitives.ResourceName(value)
      )
    override val tableStatus
        : Optional[zio.aws.timestreamwrite.model.TableStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tableStatus())
        .map(value => zio.aws.timestreamwrite.model.TableStatus.wrap(value))
    override val retentionProperties
        : Optional[zio.aws.timestreamwrite.model.RetentionProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retentionProperties())
        .map(value =>
          zio.aws.timestreamwrite.model.RetentionProperties.wrap(value)
        )
    override val creationTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.timestreamwrite.model.primitives.Date(value))
    override val lastUpdatedTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedTime())
      .map(value => zio.aws.timestreamwrite.model.primitives.Date(value))
    override val magneticStoreWriteProperties: Optional[
      zio.aws.timestreamwrite.model.MagneticStoreWriteProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.magneticStoreWriteProperties())
      .map(value =>
        zio.aws.timestreamwrite.model.MagneticStoreWriteProperties.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.Table
  ): zio.aws.timestreamwrite.model.Table.ReadOnly = new Wrapper(impl)
}
