package zio.aws.timestreamwrite.model
import zio.aws.timestreamwrite.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateTableRequest(
    databaseName: ResourceName,
    tableName: ResourceName,
    retentionProperties: Option[
      zio.aws.timestreamwrite.model.RetentionProperties
    ] = None,
    magneticStoreWriteProperties: Option[
      zio.aws.timestreamwrite.model.MagneticStoreWriteProperties
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.UpdateTableRequest = {
    import UpdateTableRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.UpdateTableRequest
      .builder()
      .databaseName(ResourceName.unwrap(databaseName): java.lang.String)
      .tableName(ResourceName.unwrap(tableName): java.lang.String)
      .optionallyWith(retentionProperties.map(value => value.buildAwsValue()))(
        _.retentionProperties
      )
      .optionallyWith(
        magneticStoreWriteProperties.map(value => value.buildAwsValue())
      )(_.magneticStoreWriteProperties)
      .build()
  }
  def asReadOnly: zio.aws.timestreamwrite.model.UpdateTableRequest.ReadOnly =
    zio.aws.timestreamwrite.model.UpdateTableRequest.wrap(buildAwsValue())
}
object UpdateTableRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.UpdateTableRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.UpdateTableRequest =
      zio.aws.timestreamwrite.model.UpdateTableRequest(
        databaseName,
        tableName,
        retentionProperties.map(value => value.asEditable),
        magneticStoreWriteProperties.map(value => value.asEditable)
      )
    def databaseName: ResourceName
    def tableName: ResourceName
    def retentionProperties
        : Option[zio.aws.timestreamwrite.model.RetentionProperties.ReadOnly]
    def magneticStoreWriteProperties: Option[
      zio.aws.timestreamwrite.model.MagneticStoreWriteProperties.ReadOnly
    ]
    def getDatabaseName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(databaseName)
    def getTableName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(tableName)
    def getRetentionProperties: ZIO[
      Any,
      AwsError,
      zio.aws.timestreamwrite.model.RetentionProperties.ReadOnly
    ] = AwsError.unwrapOptionField("retentionProperties", retentionProperties)
    def getMagneticStoreWriteProperties: ZIO[
      Any,
      AwsError,
      zio.aws.timestreamwrite.model.MagneticStoreWriteProperties.ReadOnly
    ] = AwsError.unwrapOptionField(
      "magneticStoreWriteProperties",
      magneticStoreWriteProperties
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.UpdateTableRequest
  ) extends zio.aws.timestreamwrite.model.UpdateTableRequest.ReadOnly {
    override val databaseName: ResourceName =
      zio.aws.timestreamwrite.model.primitives.ResourceName(impl.databaseName())
    override val tableName: ResourceName =
      zio.aws.timestreamwrite.model.primitives.ResourceName(impl.tableName())
    override val retentionProperties
        : Option[zio.aws.timestreamwrite.model.RetentionProperties.ReadOnly] =
      scala
        .Option(impl.retentionProperties())
        .map(value =>
          zio.aws.timestreamwrite.model.RetentionProperties.wrap(value)
        )
    override val magneticStoreWriteProperties: Option[
      zio.aws.timestreamwrite.model.MagneticStoreWriteProperties.ReadOnly
    ] = scala
      .Option(impl.magneticStoreWriteProperties())
      .map(value =>
        zio.aws.timestreamwrite.model.MagneticStoreWriteProperties.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.UpdateTableRequest
  ): zio.aws.timestreamwrite.model.UpdateTableRequest.ReadOnly = new Wrapper(
    impl
  )
}
