package zio.aws.timestreamwrite.model
import zio.aws.timestreamwrite.model.primitives.{
  MagneticStoreRetentionPeriodInDays,
  MemoryStoreRetentionPeriodInHours
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RetentionProperties(
    memoryStoreRetentionPeriodInHours: MemoryStoreRetentionPeriodInHours,
    magneticStoreRetentionPeriodInDays: MagneticStoreRetentionPeriodInDays
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.RetentionProperties = {
    import RetentionProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.RetentionProperties
      .builder()
      .memoryStoreRetentionPeriodInHours(
        MemoryStoreRetentionPeriodInHours.unwrap(
          memoryStoreRetentionPeriodInHours
        ): java.lang.Long
      )
      .magneticStoreRetentionPeriodInDays(
        MagneticStoreRetentionPeriodInDays.unwrap(
          magneticStoreRetentionPeriodInDays
        ): java.lang.Long
      )
      .build()
  }
  def asReadOnly: zio.aws.timestreamwrite.model.RetentionProperties.ReadOnly =
    zio.aws.timestreamwrite.model.RetentionProperties.wrap(buildAwsValue())
}
object RetentionProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.RetentionProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.RetentionProperties =
      zio.aws.timestreamwrite.model.RetentionProperties(
        memoryStoreRetentionPeriodInHours,
        magneticStoreRetentionPeriodInDays
      )
    def memoryStoreRetentionPeriodInHours: MemoryStoreRetentionPeriodInHours
    def magneticStoreRetentionPeriodInDays: MagneticStoreRetentionPeriodInDays
    def getMemoryStoreRetentionPeriodInHours
        : ZIO[Any, Nothing, MemoryStoreRetentionPeriodInHours] =
      ZIO.succeed(memoryStoreRetentionPeriodInHours)
    def getMagneticStoreRetentionPeriodInDays
        : ZIO[Any, Nothing, MagneticStoreRetentionPeriodInDays] =
      ZIO.succeed(magneticStoreRetentionPeriodInDays)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.RetentionProperties
  ) extends zio.aws.timestreamwrite.model.RetentionProperties.ReadOnly {
    override val memoryStoreRetentionPeriodInHours
        : MemoryStoreRetentionPeriodInHours =
      zio.aws.timestreamwrite.model.primitives
        .MemoryStoreRetentionPeriodInHours(
          impl.memoryStoreRetentionPeriodInHours()
        )
    override val magneticStoreRetentionPeriodInDays
        : MagneticStoreRetentionPeriodInDays =
      zio.aws.timestreamwrite.model.primitives
        .MagneticStoreRetentionPeriodInDays(
          impl.magneticStoreRetentionPeriodInDays()
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.RetentionProperties
  ): zio.aws.timestreamwrite.model.RetentionProperties.ReadOnly = new Wrapper(
    impl
  )
}
