package zio.aws.timestreamwrite.model
import java.lang.Integer
import zio.aws.timestreamwrite.model.primitives.{PaginationLimit, ResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListTablesRequest(
    databaseName: Option[ResourceName] = None,
    nextToken: Option[String] = None,
    maxResults: Option[PaginationLimit] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.ListTablesRequest = {
    import ListTablesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.ListTablesRequest
      .builder()
      .optionallyWith(
        databaseName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.databaseName)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => PaginationLimit.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.timestreamwrite.model.ListTablesRequest.ReadOnly =
    zio.aws.timestreamwrite.model.ListTablesRequest.wrap(buildAwsValue())
}
object ListTablesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.ListTablesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.ListTablesRequest =
      zio.aws.timestreamwrite.model.ListTablesRequest(
        databaseName.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def databaseName: Option[ResourceName]
    def nextToken: Option[String]
    def maxResults: Option[PaginationLimit]
    def getDatabaseName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, PaginationLimit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.ListTablesRequest
  ) extends zio.aws.timestreamwrite.model.ListTablesRequest.ReadOnly {
    override val databaseName: Option[ResourceName] = scala
      .Option(impl.databaseName())
      .map(value =>
        zio.aws.timestreamwrite.model.primitives.ResourceName(value)
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[PaginationLimit] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.timestreamwrite.model.primitives.PaginationLimit(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.ListTablesRequest
  ): zio.aws.timestreamwrite.model.ListTablesRequest.ReadOnly = new Wrapper(
    impl
  )
}
