package zio.aws.timestreamwrite.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateDatabaseResponse(
    database: Option[zio.aws.timestreamwrite.model.Database] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.CreateDatabaseResponse = {
    import CreateDatabaseResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.CreateDatabaseResponse
      .builder()
      .optionallyWith(database.map(value => value.buildAwsValue()))(_.database)
      .build()
  }
  def asReadOnly
      : zio.aws.timestreamwrite.model.CreateDatabaseResponse.ReadOnly =
    zio.aws.timestreamwrite.model.CreateDatabaseResponse.wrap(buildAwsValue())
}
object CreateDatabaseResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.CreateDatabaseResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.CreateDatabaseResponse =
      zio.aws.timestreamwrite.model
        .CreateDatabaseResponse(database.map(value => value.asEditable))
    def database: Option[zio.aws.timestreamwrite.model.Database.ReadOnly]
    def getDatabase
        : ZIO[Any, AwsError, zio.aws.timestreamwrite.model.Database.ReadOnly] =
      AwsError.unwrapOptionField("database", database)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.CreateDatabaseResponse
  ) extends zio.aws.timestreamwrite.model.CreateDatabaseResponse.ReadOnly {
    override val database
        : Option[zio.aws.timestreamwrite.model.Database.ReadOnly] = scala
      .Option(impl.database())
      .map(value => zio.aws.timestreamwrite.model.Database.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.CreateDatabaseResponse
  ): zio.aws.timestreamwrite.model.CreateDatabaseResponse.ReadOnly =
    new Wrapper(impl)
}
