package zio.aws.timestreamwrite.model
import zio.aws.timestreamwrite.model.primitives.{
  StringValue2048,
  ResourceCreateAPIName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateDatabaseRequest(
    databaseName: ResourceCreateAPIName,
    kmsKeyId: Option[StringValue2048] = None,
    tags: Option[Iterable[zio.aws.timestreamwrite.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.CreateDatabaseRequest = {
    import CreateDatabaseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.CreateDatabaseRequest
      .builder()
      .databaseName(
        ResourceCreateAPIName.unwrap(databaseName): java.lang.String
      )
      .optionallyWith(
        kmsKeyId.map(value => StringValue2048.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.timestreamwrite.model.CreateDatabaseRequest.ReadOnly =
    zio.aws.timestreamwrite.model.CreateDatabaseRequest.wrap(buildAwsValue())
}
object CreateDatabaseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.CreateDatabaseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.CreateDatabaseRequest =
      zio.aws.timestreamwrite.model.CreateDatabaseRequest(
        databaseName,
        kmsKeyId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def databaseName: ResourceCreateAPIName
    def kmsKeyId: Option[StringValue2048]
    def tags: Option[List[zio.aws.timestreamwrite.model.Tag.ReadOnly]]
    def getDatabaseName: ZIO[Any, Nothing, ResourceCreateAPIName] =
      ZIO.succeed(databaseName)
    def getKmsKeyId: ZIO[Any, AwsError, StringValue2048] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.timestreamwrite.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.CreateDatabaseRequest
  ) extends zio.aws.timestreamwrite.model.CreateDatabaseRequest.ReadOnly {
    override val databaseName: ResourceCreateAPIName =
      zio.aws.timestreamwrite.model.primitives
        .ResourceCreateAPIName(impl.databaseName())
    override val kmsKeyId: Option[StringValue2048] = scala
      .Option(impl.kmsKeyId())
      .map(value =>
        zio.aws.timestreamwrite.model.primitives.StringValue2048(value)
      )
    override val tags
        : Option[List[zio.aws.timestreamwrite.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.timestreamwrite.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.CreateDatabaseRequest
  ): zio.aws.timestreamwrite.model.CreateDatabaseRequest.ReadOnly = new Wrapper(
    impl
  )
}
