package zio.aws.timestreamwrite.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateTableResponse(
    table: Option[zio.aws.timestreamwrite.model.Table] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.UpdateTableResponse = {
    import UpdateTableResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.UpdateTableResponse
      .builder()
      .optionallyWith(table.map(value => value.buildAwsValue()))(_.table)
      .build()
  }
  def asReadOnly: zio.aws.timestreamwrite.model.UpdateTableResponse.ReadOnly =
    zio.aws.timestreamwrite.model.UpdateTableResponse.wrap(buildAwsValue())
}
object UpdateTableResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.UpdateTableResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.UpdateTableResponse =
      zio.aws.timestreamwrite.model
        .UpdateTableResponse(table.map(value => value.asEditable))
    def table: Option[zio.aws.timestreamwrite.model.Table.ReadOnly]
    def getTable
        : ZIO[Any, AwsError, zio.aws.timestreamwrite.model.Table.ReadOnly] =
      AwsError.unwrapOptionField("table", table)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.UpdateTableResponse
  ) extends zio.aws.timestreamwrite.model.UpdateTableResponse.ReadOnly {
    override val table: Option[zio.aws.timestreamwrite.model.Table.ReadOnly] =
      scala
        .Option(impl.table())
        .map(value => zio.aws.timestreamwrite.model.Table.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.UpdateTableResponse
  ): zio.aws.timestreamwrite.model.UpdateTableResponse.ReadOnly = new Wrapper(
    impl
  )
}
