package zio.aws.timestreamwrite.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DataSourceConfiguration(
    dataSourceS3Configuration: zio.aws.timestreamwrite.model.DataSourceS3Configuration,
    csvConfiguration: Optional[zio.aws.timestreamwrite.model.CsvConfiguration] =
      Optional.Absent,
    dataFormat: zio.aws.timestreamwrite.model.BatchLoadDataFormat
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.DataSourceConfiguration = {
    import DataSourceConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.DataSourceConfiguration
      .builder()
      .dataSourceS3Configuration(dataSourceS3Configuration.buildAwsValue())
      .optionallyWith(csvConfiguration.map(value => value.buildAwsValue()))(
        _.csvConfiguration
      )
      .dataFormat(dataFormat.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.timestreamwrite.model.DataSourceConfiguration.ReadOnly =
    zio.aws.timestreamwrite.model.DataSourceConfiguration.wrap(buildAwsValue())
}
object DataSourceConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.DataSourceConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.DataSourceConfiguration =
      zio.aws.timestreamwrite.model.DataSourceConfiguration(
        dataSourceS3Configuration.asEditable,
        csvConfiguration.map(value => value.asEditable),
        dataFormat
      )
    def dataSourceS3Configuration
        : zio.aws.timestreamwrite.model.DataSourceS3Configuration.ReadOnly
    def csvConfiguration
        : Optional[zio.aws.timestreamwrite.model.CsvConfiguration.ReadOnly]
    def dataFormat: zio.aws.timestreamwrite.model.BatchLoadDataFormat
    def getDataSourceS3Configuration: ZIO[
      Any,
      Nothing,
      zio.aws.timestreamwrite.model.DataSourceS3Configuration.ReadOnly
    ] = ZIO.succeed(dataSourceS3Configuration)
    def getCsvConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.timestreamwrite.model.CsvConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("csvConfiguration", csvConfiguration)
    def getDataFormat
        : ZIO[Any, Nothing, zio.aws.timestreamwrite.model.BatchLoadDataFormat] =
      ZIO.succeed(dataFormat)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.DataSourceConfiguration
  ) extends zio.aws.timestreamwrite.model.DataSourceConfiguration.ReadOnly {
    override val dataSourceS3Configuration
        : zio.aws.timestreamwrite.model.DataSourceS3Configuration.ReadOnly =
      zio.aws.timestreamwrite.model.DataSourceS3Configuration
        .wrap(impl.dataSourceS3Configuration())
    override val csvConfiguration
        : Optional[zio.aws.timestreamwrite.model.CsvConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.csvConfiguration())
        .map(value =>
          zio.aws.timestreamwrite.model.CsvConfiguration.wrap(value)
        )
    override val dataFormat: zio.aws.timestreamwrite.model.BatchLoadDataFormat =
      zio.aws.timestreamwrite.model.BatchLoadDataFormat.wrap(impl.dataFormat())
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.DataSourceConfiguration
  ): zio.aws.timestreamwrite.model.DataSourceConfiguration.ReadOnly =
    new Wrapper(impl)
}
